/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import java.io.Serializable;

public class SourceInfo
implements Serializable {
    private final String source;
    private final int beginSrcLine;
    private final int endSrcLine;

    public SourceInfo(String file, int beginLine) {
        this.source = file;
        this.beginSrcLine = beginLine;
        this.endSrcLine = beginLine;
    }

    public SourceInfo(String file, int beginLine, int endLine) {
        this.source = file;
        this.beginSrcLine = beginLine;
        this.endSrcLine = endLine;
    }

    public SourceInfo(SourceInfo o) {
        if (o == null) {
            this.source = null;
            this.beginSrcLine = 0;
            this.endSrcLine = 0;
        } else {
            this.source = o.source;
            this.beginSrcLine = o.beginSrcLine;
            this.endSrcLine = o.endSrcLine;
        }
    }

    public SourceInfo clone() {
        return this;
    }

    public String getSrcFile() {
        return this.source;
    }

    public int getSrcLine() {
        return this.beginSrcLine;
    }

    public int getBeginSrcLine() {
        return this.beginSrcLine;
    }

    public int getEndSrcLine() {
        return this.endSrcLine;
    }

    public String toString() {
        return (this.source == null ? "nofile" : this.source) + (this.beginSrcLine >= 0 ? ":" + this.beginSrcLine : "");
    }
}

