/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

public final class PredicateIndicator {
    private final String functor;
    private final int arity;
    private final int hash;

    public PredicateIndicator(String functor, int arity) {
        this.functor = functor;
        this.arity = arity;
        this.hash = this.calcHash();
    }

    public PredicateIndicator(String prefix, PredicateIndicator pi) {
        this.functor = prefix + pi.functor;
        this.arity = pi.arity;
        this.hash = this.calcHash();
    }

    public String getFunctor() {
        return this.functor;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof PredicateIndicator && o.hashCode() == this.hashCode()) {
            PredicateIndicator pi = (PredicateIndicator)o;
            return this.arity == pi.arity && this.functor.equals(pi.functor);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private int calcHash() {
        int PRIME = 31;
        int t = 31 * this.arity;
        if (this.functor != null) {
            t = 31 * t + this.functor.hashCode();
        }
        return t;
    }

    public String toString() {
        return this.functor + "/" + this.arity;
    }
}

