/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.Atom;
import cartago.manual.syntax.DefaultTerm;
import cartago.manual.syntax.Term;

public final class NumberTerm
extends DefaultTerm {
    private static final long serialVersionUID = 1L;
    private final double value;

    public NumberTerm() {
        this.value = 0.0;
    }

    public NumberTerm(String sn) throws Exception {
        this.value = Double.parseDouble(sn);
    }

    public NumberTerm(double vl) {
        this.value = vl;
    }

    public NumberTerm(NumberTerm t) {
        this.value = t.solve();
        this.srcInfo = t.srcInfo;
    }

    public double solve() {
        return this.value;
    }

    @Override
    public NumberTerm clone() {
        return this;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Term && ((Term)o).isNumeric() && !((Term)o).isArithExpr()) {
            NumberTerm st = (NumberTerm)o;
            try {
                return this.solve() == st.solve();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        return 37 * (int)this.solve();
    }

    @Override
    public int compareTo(Term o) {
        if (o instanceof NumberTerm) {
            NumberTerm st = (NumberTerm)o;
            if (this.solve() > st.solve()) {
                return 1;
            }
            if (this.solve() < st.solve()) {
                return -1;
            }
            return 0;
        }
        if (o instanceof Atom) {
            return -1;
        }
        return super.compareTo(o);
    }

    public String toString() {
        long r = Math.round(this.value);
        if (this.value == (double)r) {
            return String.valueOf(r);
        }
        return String.valueOf(this.value);
    }
}

