/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.Atom;
import cartago.manual.syntax.Literal;
import cartago.manual.syntax.PredicateIndicator;
import cartago.manual.syntax.Structure;
import cartago.manual.syntax.Term;

public class LiteralImpl
extends Structure {
    private static final long serialVersionUID = 1L;
    private boolean type = true;

    public LiteralImpl(String functor) {
        super(functor);
    }

    public LiteralImpl(boolean pos, String functor) {
        super(functor);
        this.type = pos;
    }

    public LiteralImpl(Literal l) {
        super(l);
        this.type = !l.negated();
    }

    public LiteralImpl(boolean pos, Literal l) {
        super(l);
        this.type = pos;
    }

    protected LiteralImpl(String functor, int terms) {
        super(functor, terms);
    }

    @Override
    public boolean isAtom() {
        return super.isAtom() && !this.negated();
    }

    @Override
    public boolean canBeAddedInBB() {
        return true;
    }

    @Override
    public boolean negated() {
        return !this.type;
    }

    @Override
    public Literal setNegated(boolean b) {
        this.type = b;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof LiteralImpl) {
            LiteralImpl l = (LiteralImpl)o;
            return this.type == l.type && this.hashCode() == l.hashCode() && super.equals(l);
        }
        if (o instanceof Atom && !this.negated()) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public String getErrorMsg() {
        String src = this.getSrcInfo() == null ? "" : " (" + this.getSrcInfo() + ")";
        return "Error in '" + this + "'" + src;
    }

    @Override
    public int compareTo(Term t) {
        if (t.isLiteral()) {
            Literal tl = (Literal)t;
            if (!this.negated() && tl.negated()) {
                return -1;
            }
            if (this.negated() && !tl.negated()) {
                return 1;
            }
        }
        return super.compareTo(t);
    }

    @Override
    public Term clone() {
        return new LiteralImpl(this);
    }

    @Override
    protected int calcHashCode() {
        int result = super.calcHashCode();
        if (this.negated()) {
            result += 3271;
        }
        return result;
    }

    @Override
    public PredicateIndicator getPredicateIndicator() {
        if (this.predicateIndicatorCache == null) {
            this.predicateIndicatorCache = new PredicateIndicator((this.type ? "" : "~") + this.getFunctor(), this.getArity());
        }
        return this.predicateIndicatorCache;
    }

    @Override
    public String toString() {
        if (this.type) {
            return super.toString();
        }
        return "~" + super.toString();
    }
}

