/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.Atom;
import cartago.manual.syntax.DefaultTerm;
import cartago.manual.syntax.ListTerm;
import cartago.manual.syntax.LiteralImpl;
import cartago.manual.syntax.PredicateIndicator;
import cartago.manual.syntax.Structure;
import cartago.manual.syntax.Term;
import cartago.manual.syntax.VarTerm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Literal
extends DefaultTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Literal.class.getName());
    public static final boolean LPos = true;
    public static final boolean LNeg = false;
    public static final Literal LTrue = new TrueLiteral();
    public static final Literal LFalse = new FalseLiteral();
    protected PredicateIndicator predicateIndicatorCache = null;
    private static final List<VarTerm> emptyListVar = new ArrayList<VarTerm>();

    public Literal copy() {
        return (Literal)this.clone();
    }

    public abstract String getFunctor();

    @Override
    public boolean isLiteral() {
        return true;
    }

    public PredicateIndicator getPredicateIndicator() {
        if (this.predicateIndicatorCache == null) {
            this.predicateIndicatorCache = new PredicateIndicator(this.getFunctor(), this.getArity());
        }
        return this.predicateIndicatorCache;
    }

    public int getArity() {
        return 0;
    }

    public boolean hasTerm() {
        return false;
    }

    public List<Term> getTerms() {
        return Structure.emptyTermList;
    }

    public Term[] getTermsArray() {
        return this.getTerms().toArray(Structure.emptyTermArray);
    }

    public List<VarTerm> getSingletonVars() {
        return emptyListVar;
    }

    public ListTerm getSources() {
        return new ListTerm();
    }

    public boolean hasSource() {
        return false;
    }

    public boolean hasSource(Term agName) {
        return false;
    }

    public boolean canBeAddedInBB() {
        return false;
    }

    public boolean negated() {
        return false;
    }

    public boolean equalsAsStructure(Object p) {
        return false;
    }

    public void addTerm(Term t) {
        logger.log(Level.SEVERE, "addTerm is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public void delTerm(int index) {
        logger.log(Level.SEVERE, "delTerm is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public Literal addTerms(Term ... ts) {
        logger.log(Level.SEVERE, "addTerms is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public Literal addTerms(List<Term> l) {
        logger.log(Level.SEVERE, "addTerms is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public Term getTerm(int i) {
        logger.log(Level.SEVERE, "getTerm(i) is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public Literal setTerms(List<Term> l) {
        logger.log(Level.SEVERE, "setTerms is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public void setTerm(int i, Term t) {
        logger.log(Level.SEVERE, "setTerm is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public void addSource(Term agName) {
        logger.log(Level.SEVERE, "addSource is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public boolean delSource(Term agName) {
        logger.log(Level.SEVERE, "delSource is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return false;
    }

    public void delSources() {
        logger.log(Level.SEVERE, "delSources is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
    }

    public Literal setNegated(boolean b) {
        logger.log(Level.SEVERE, "setNegated is not implemented in the class " + this.getClass().getSimpleName(), new Exception());
        return null;
    }

    public ListTerm getAsListOfTerms() {
        ListTerm l = new ListTerm();
        l.add(new LiteralImpl(!this.negated(), this.getFunctor()));
        ListTerm lt = new ListTerm();
        lt.addAll(this.getTerms());
        l.add(lt);
        return l;
    }

    public static Literal newFromListOfTerms(ListTerm lt) throws Exception {
        try {
            Iterator<Term> i = lt.iterator();
            Term tfunctor = i.next();
            boolean pos = true;
            if (tfunctor.isLiteral() && ((Literal)tfunctor).negated()) {
                pos = false;
            }
            LiteralImpl l = new LiteralImpl(pos, ((Atom)tfunctor).getFunctor());
            if (i.hasNext()) {
                ((Literal)l).setTerms(((ListTerm)i.next()).cloneLT());
            }
            return l;
        }
        catch (Exception e) {
            throw new Exception("Error creating literal from " + lt);
        }
    }

    public Literal forceFullLiteralImpl() {
        if (this.isAtom() && !(this instanceof LiteralImpl)) {
            return new LiteralImpl(this);
        }
        return this;
    }

    static final class FalseLiteral
    extends LiteralImpl {
        public FalseLiteral() {
            super("false", 0);
        }

        @Override
        public boolean canBeAddedInBB() {
            return false;
        }
    }

    static final class TrueLiteral
    extends LiteralImpl {
        public TrueLiteral() {
            super("true", 0);
        }

        @Override
        public boolean canBeAddedInBB() {
            return false;
        }
    }
}

