/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.Structure;
import cartago.manual.syntax.Term;
import cartago.manual.syntax.VarTerm;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;

public class ListTerm
extends Structure
implements List<Term> {
    private static final long serialVersionUID = 1L;
    public static final String LIST_FUNCTOR = ".";
    private Term term;
    private Term next;

    public ListTerm() {
        super(LIST_FUNCTOR, 0);
    }

    private ListTerm(Term t, Term n) {
        super(LIST_FUNCTOR, 0);
        this.term = t;
        this.next = n;
    }

    @Override
    public ListTerm clone() {
        ListTerm t = new ListTerm();
        if (this.term != null) {
            t.term = this.term.clone();
        }
        if (this.next != null) {
            t.next = this.next.clone();
        }
        return t;
    }

    public ListTerm cloneLT() {
        return this.clone();
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof Term && ((Term)t).isVar()) {
            return false;
        }
        if (t instanceof ListTerm) {
            ListTerm tAsList = (ListTerm)t;
            if (this.term == null && tAsList.getTerm() != null) {
                return false;
            }
            if (this.term != null && !this.term.equals(tAsList.getTerm())) {
                return false;
            }
            if (this.next == null && tAsList.getNext() != null) {
                return false;
            }
            if (this.next != null) {
                return this.next.equals(tAsList.getNext());
            }
            return true;
        }
        return false;
    }

    @Override
    public int calcHashCode() {
        int code = 37;
        if (this.term != null) {
            code += this.term.hashCode();
        }
        if (this.next != null) {
            code += this.next.hashCode();
        }
        return code;
    }

    public void setTerm(Term t) {
        this.term = t;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setNext(Term l) {
        this.next = l;
    }

    public ListTerm getNext() {
        if (this.next instanceof ListTerm) {
            return (ListTerm)this.next;
        }
        return null;
    }

    @Override
    public int getArity() {
        if (this.isEmpty()) {
            return 0;
        }
        return 2;
    }

    @Override
    public Term getTerm(int i) {
        if (i == 0) {
            return this.term;
        }
        if (i == 1) {
            return this.next;
        }
        return null;
    }

    @Override
    public void setTerm(int i, Term t) {
        if (i == 0) {
            this.term = t;
        }
        if (i == 1) {
            this.next = t;
        }
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isTail()) {
            return 1;
        }
        return this.getNext().size() + 1;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.term == null;
    }

    public boolean isEnd() {
        return this.isEmpty() || this.isTail();
    }

    @Override
    public boolean isGround() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.isTail()) {
            return false;
        }
        if (this.term != null && this.term.isGround()) {
            return this.getNext().isGround();
        }
        return false;
    }

    public boolean isTail() {
        return this.next != null && this.next.isVar();
    }

    public VarTerm getTail() {
        if (this.isTail()) {
            return (VarTerm)this.next;
        }
        if (this.next != null) {
            return this.getNext().getTail();
        }
        return null;
    }

    public void setTail(VarTerm v) {
        if (this.getNext().isEmpty()) {
            this.next = v;
        } else {
            this.getNext().setTail(v);
        }
    }

    @Override
    public ListTerm getLast() {
        if (this.isEnd()) {
            return this;
        }
        if (this.next != null) {
            return this.getNext().getLast();
        }
        return null;
    }

    public ListTerm getPenultimate() {
        if (this.getNext() == null) {
            return null;
        }
        if (this.isTail()) {
            return this;
        }
        if (this.getNext().isEnd() && !this.getNext().isTail()) {
            return this;
        }
        return this.getNext().getPenultimate();
    }

    @Override
    public Term removeLast() {
        ListTerm p = this.getPenultimate();
        if (p != null) {
            Term b = p.getTerm();
            p.setTerm(null);
            p.setNext(null);
            return b;
        }
        return null;
    }

    public ListTerm append(Term t) {
        if (this.isEmpty()) {
            this.term = t;
            this.next = new ListTerm();
            return this;
        }
        if (this.isTail()) {
            return null;
        }
        return this.getNext().append(t);
    }

    public ListTerm concat(ListTerm lt) {
        if (this.isEmpty()) {
            this.setValuesFrom(lt);
        } else if (((ListTerm)this.next).isEmpty()) {
            this.next = lt;
        } else {
            ((ListTerm)this.next).concat(lt);
        }
        return lt.getLast();
    }

    public ListTerm reverse() {
        return this.reverse_internal(new ListTerm());
    }

    private ListTerm reverse_internal(ListTerm r) {
        if (this.isEmpty()) {
            return r;
        }
        if (this.isTail()) {
            r = new ListTerm(this.term.clone(), r);
            r.setTail((VarTerm)this.next.clone());
            return r;
        }
        return ((ListTerm)this.next).reverse_internal(new ListTerm(this.term.clone(), r));
    }

    public ListTerm union(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(lt);
        set.addAll(this);
        return this.setToList(set);
    }

    public ListTerm intersection(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(lt);
        set.retainAll(this);
        return this.setToList(set);
    }

    public ListTerm difference(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(this);
        set.removeAll(lt);
        return this.setToList(set);
    }

    private ListTerm setToList(Set<Term> set) {
        ListTerm result;
        ListTerm tail = result = new ListTerm();
        for (Term t : set) {
            tail = tail.append(t.clone());
        }
        return result;
    }

    public Iterator<ListTerm> listTermIterator() {
        return new ListTermIterator<ListTerm>(this){

            @Override
            public ListTerm next() {
                this.moveNext();
                return this.current;
            }
        };
    }

    @Override
    public Iterator<Term> iterator() {
        return new ListTermIterator<Term>(this){

            @Override
            public boolean hasNext() {
                return this.nextLT != null && !this.nextLT.isEmpty() && this.nextLT.isList();
            }

            @Override
            public Term next() {
                this.moveNext();
                return this.current.getTerm();
            }
        };
    }

    public List<Term> getAsList() {
        ArrayList<Term> l = new ArrayList<Term>();
        for (Term t : this) {
            l.add(t);
        }
        return l;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        ListTerm l = this;
        while (!l.isEmpty()) {
            s.append(l.getTerm());
            if (l.isTail()) {
                s.append('|');
                s.append(l.getNext());
                break;
            }
            if ((l = l.getNext()).isEmpty()) continue;
            s.append(',');
        }
        s.append(']');
        return s.toString();
    }

    @Override
    public void add(int index, Term o) {
        if (index == 0) {
            ListTerm n = new ListTerm(this.term, this.next);
            this.term = o;
            this.next = n;
        } else if (index > 0 && this.getNext() != null) {
            this.getNext().add(index - 1, o);
        }
    }

    @Override
    public boolean add(Term o) {
        return this.append(o) != null;
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null) {
            return false;
        }
        ListTerm lt = this;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            lt = lt.append((Term)i.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        Iterator i = c.iterator();
        int p = index;
        while (i.hasNext()) {
            this.add(p, (Term)i.next());
            ++p;
        }
        return true;
    }

    @Override
    public void clear() {
        this.term = null;
        this.next = null;
    }

    @Override
    public boolean contains(Object o) {
        if (this.term != null && this.term.equals(o)) {
            return true;
        }
        if (this.getNext() != null) {
            return this.getNext().contains(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        boolean r = true;
        Iterator i = c.iterator();
        while (i.hasNext() && r) {
            r = r && this.contains(i.next());
        }
        return r;
    }

    @Override
    public Term get(int index) {
        if (index == 0) {
            return this.term;
        }
        if (this.getNext() != null) {
            return this.getNext().get(index - 1);
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        int n;
        if (this.term.equals(o)) {
            return 0;
        }
        if (this.getNext() != null && (n = this.getNext().indexOf(o)) >= 0) {
            return n + 1;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.getAsList().lastIndexOf(arg0);
    }

    @Override
    public ListIterator<Term> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Term> listIterator(final int startIndex) {
        final ListTerm list = this;
        return new ListIterator<Term>(){
            int pos;
            int last;
            int size;
            {
                this.pos = startIndex;
                this.last = -1;
                this.size = ListTerm.this.size();
            }

            @Override
            public void add(Term o) {
                list.add(this.last, o);
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > startIndex;
            }

            @Override
            public Term next() {
                this.last = this.pos++;
                return ListTerm.this.get(this.last);
            }

            @Override
            public int nextIndex() {
                return this.pos + 1;
            }

            @Override
            public Term previous() {
                this.last = this.pos--;
                return ListTerm.this.get(this.last);
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void remove() {
                list.remove(this.last);
            }

            @Override
            public void set(Term o) {
                this.remove();
                this.add(o);
            }
        };
    }

    protected void setValuesFrom(ListTerm lt) {
        this.term = lt.getTerm();
        this.next = lt.getNext();
    }

    @Override
    public Term remove(int index) {
        if (index == 0) {
            Term bt = this.term;
            if (this.getNext() != null) {
                this.setValuesFrom(this.getNext());
            } else {
                this.clear();
            }
            return bt;
        }
        if (this.getNext() != null) {
            return this.getNext().remove(index - 1);
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.term != null && this.term.equals(o)) {
            if (this.getNext() != null) {
                this.setValuesFrom(this.getNext());
            } else {
                this.clear();
            }
            return true;
        }
        if (this.getNext() != null) {
            return this.getNext().remove(o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean r = true;
        Iterator i = c.iterator();
        while (i.hasNext() && r) {
            r = r && this.remove(i.next());
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean r = true;
        for (Term t : this) {
            if (c.contains(t)) continue;
            r = r && this.remove(t);
        }
        return r;
    }

    @Override
    public Term set(int index, Term t) {
        if (index == 0) {
            this.term = t;
            return t;
        }
        if (this.getNext() != null) {
            return this.getNext().set(index - 1, t);
        }
        return null;
    }

    @Override
    public List<Term> subList(int arg0, int arg1) {
        return this.getAsList().subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int s = this.size();
        if (a.length < s) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), s);
        }
        int i = 0;
        for (Term t : this) {
            a[i++] = t;
        }
        if (a.length > s) {
            a[s] = null;
        }
        return a;
    }

    private abstract class ListTermIterator<T>
    implements Iterator<T> {
        ListTerm nextLT;
        ListTerm current = null;

        public ListTermIterator(ListTerm lt) {
            this.nextLT = lt;
        }

        @Override
        public boolean hasNext() {
            return this.nextLT != null;
        }

        public void moveNext() {
            this.current = this.nextLT;
            this.nextLT = this.nextLT.getNext();
        }

        @Override
        public void remove() {
            if (this.current != null && this.nextLT != null) {
                this.current.setTerm(this.nextLT.getTerm());
                this.current.setNext(this.nextLT.getNext());
                this.nextLT = this.current;
            }
        }
    }
}

