/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.ListTerm;
import cartago.manual.syntax.Literal;
import cartago.manual.syntax.Term;

public class Atom
extends Literal {
    private static final long serialVersionUID = 1L;
    private final String functor;

    public Atom(String functor) {
        this.functor = functor;
    }

    public Atom(Literal l) {
        this.functor = l.getFunctor();
        this.predicateIndicatorCache = l.predicateIndicatorCache;
        this.hashCodeCache = l.hashCodeCache;
        this.srcInfo = l.srcInfo;
    }

    @Override
    public String getFunctor() {
        return this.functor;
    }

    @Override
    public Term clone() {
        return this;
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Atom) {
            Atom a = (Atom)o;
            return a.isAtom() && this.getFunctor().equals(a.getFunctor());
        }
        return false;
    }

    @Override
    public int compareTo(Term t) {
        if (t.isNumeric()) {
            return 1;
        }
        if (this.isList() && !t.isList()) {
            return 1;
        }
        if (!this.isList() && t.isList()) {
            return -1;
        }
        if (this.isList() && t.isList()) {
            int l2s;
            ListTerm l1 = (ListTerm)this;
            ListTerm l2 = (ListTerm)t;
            int l1s = l1.size();
            if (l1s > (l2s = l2.size())) {
                return 1;
            }
            if (l2s > l1s) {
                return -1;
            }
            return 0;
        }
        if (t instanceof Atom) {
            Atom tAsAtom = (Atom)t;
            return this.getFunctor().compareTo(tAsAtom.getFunctor());
        }
        return super.compareTo(t);
    }

    @Override
    protected int calcHashCode() {
        return this.getFunctor().hashCode();
    }

    public String toString() {
        return this.functor;
    }
}

