/*
 * Decompiled with CFR 0.152.
 */
package cartago.manual.syntax;

import cartago.manual.syntax.BinaryStructure;
import cartago.manual.syntax.NumberTerm;

public class ArithExpr
extends BinaryStructure {
    private static final long serialVersionUID = 1L;
    private ArithmeticOp op = ArithmeticOp.none;

    public ArithExpr(NumberTerm t1, ArithmeticOp oper, NumberTerm t2) {
        super(t1, oper.toString(), t2);
    }

    public ArithExpr(ArithmeticOp oper, NumberTerm t2) {
        super(oper.toString(), t2);
    }

    @Override
    public ArithExpr clone() {
        return new ArithExpr(this.getLHS(), this.getOp(), this.getRHS());
    }

    public ArithmeticOp getOp() {
        return this.op;
    }

    @Override
    public NumberTerm getLHS() {
        return (NumberTerm)this.getTerm(1);
    }

    @Override
    public NumberTerm getRHS() {
        return (NumberTerm)this.getTerm(0);
    }

    @Override
    public String toString() {
        if (this.isUnary()) {
            return "(" + (Object)((Object)this.op) + this.getTerm(0) + ")";
        }
        return "(" + this.getTerm(0) + (Object)((Object)this.op) + this.getTerm(1) + ")";
    }

    public static enum ArithmeticOp {
        none{

            public String toString() {
                return "";
            }
        }
        ,
        plus{

            public String toString() {
                return "+";
            }
        }
        ,
        minus{

            public String toString() {
                return "-";
            }
        }
        ,
        times{

            public String toString() {
                return "*";
            }
        }
        ,
        div{

            public String toString() {
                return "/";
            }
        }
        ,
        mod{

            public String toString() {
                return " mod ";
            }
        }
        ,
        pow{

            public String toString() {
                return "**";
            }
        }
        ,
        intdiv{

            public String toString() {
                return " div ";
            }
        };

    }
}

