/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.rmi;

import cartago.AgentBody;
import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CARTAGO_VERSION;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.CartagoService;
import cartago.CartagoWorkspace;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ICartagoLogger;
import cartago.NodeId;
import cartago.Op;
import cartago.OpId;
import cartago.infrastructure.rmi.AgentBodyProxy;
import cartago.infrastructure.rmi.AgentBodyRemote;
import cartago.infrastructure.rmi.GarbageBodyCollectorAgent;
import cartago.infrastructure.rmi.ICartagoNodeRemote;
import cartago.security.AgentCredential;
import cartago.security.SecurityException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CartagoNodeRemote
extends UnicastRemoteObject
implements ICartagoNodeRemote {
    private String fullAddress;
    private ConcurrentLinkedQueue<AgentBodyRemote> remoteCtxs = new ConcurrentLinkedQueue();
    private GarbageBodyCollectorAgent garbageCollector = new GarbageBodyCollectorAgent(this.remoteCtxs, 1000L, 10000L);

    public CartagoNodeRemote(CartagoNode node) throws Exception {
        this.garbageCollector.start();
    }

    public String getAddress() {
        return this.fullAddress;
    }

    public void install(String address, int port) throws Exception {
        LocateRegistry.createRegistry(port);
        this.fullAddress = address + ":" + port;
        Naming.bind("rmi://" + this.fullAddress + "/cartago_node", this);
    }

    public void shutdownService() {
        this.garbageCollector.stopActivity();
        try {
            Naming.unbind("rmi://" + this.fullAddress + "/cartago_node");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void registerLogger(String wspName, ICartagoLogger logger) throws RemoteException, CartagoException {
        CartagoService.registerLogger(wspName, logger);
    }

    @Override
    public ICartagoContext join(String wspName, AgentCredential cred, ICartagoCallback callback) throws SecurityException, RemoteException, CartagoException {
        CartagoNode node = CartagoNode.getInstance();
        CartagoWorkspace wsp = node.getWorkspace(wspName);
        ICartagoContext ctx = wsp.join(cred, callback);
        AgentBodyRemote rctx = new AgentBodyRemote((AgentBody)ctx);
        this.remoteCtxs.add(rctx);
        AgentBodyProxy proxy = new AgentBodyProxy(rctx);
        return proxy;
    }

    @Override
    public void quit(String wspName, AgentId id) throws RemoteException, CartagoException {
        CartagoNode node = CartagoNode.getInstance();
        CartagoWorkspace wsp = node.getWorkspace(wspName);
        wsp.getKernel().quitAgent(id);
        Iterator<AgentBodyRemote> it = this.remoteCtxs.iterator();
        while (it.hasNext()) {
            AgentBodyRemote c = it.next();
            if (!c.getAgentId().equals(id)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public OpId execInterArtifactOp(ICartagoCallback callback, long callbackId, AgentId userId, ArtifactId srcId, ArtifactId targetId, Op op, long timeout, IAlignmentTest test) throws RemoteException, CartagoException {
        CartagoNode node = CartagoNode.getInstance();
        String wspName = targetId.getWorkspaceId().getName();
        CartagoWorkspace wsp = node.getWorkspace(wspName);
        return wsp.execInterArtifactOp(callback, callbackId, userId, srcId, targetId, op, timeout, test);
    }

    @Override
    public String getVersion() throws CartagoException, RemoteException {
        return CARTAGO_VERSION.getID();
    }

    @Override
    public NodeId getNodeId() throws CartagoException, RemoteException {
        return CartagoNode.getInstance().getId();
    }
}

