/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.rmi;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.CartagoException;
import cartago.ICartagoLogger;
import cartago.IEventFilter;
import cartago.Op;
import cartago.OpId;
import cartago.Tuple;
import cartago.infrastructure.rmi.ICartagoLoggerRemote;
import java.io.Serializable;
import java.rmi.RemoteException;

public class CartagoLoggerProxy
implements ICartagoLogger,
Serializable {
    private ICartagoLoggerRemote logger;

    CartagoLoggerProxy(ICartagoLoggerRemote logger) {
        this.logger = logger;
    }

    @Override
    public void agentJoined(long when, AgentId id) throws CartagoException {
        try {
            this.logger.agentJoined(when, id);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void agentQuit(long when, AgentId id) throws CartagoException {
        try {
            this.logger.agentQuit(when, id);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void artifactCreated(long when, ArtifactId id, AgentId creator) throws CartagoException {
        try {
            this.logger.artifactCreated(when, id, creator);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void artifactDisposed(long when, ArtifactId id, AgentId disposer) throws CartagoException {
        try {
            this.logger.artifactDisposed(when, id, disposer);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void artifactFocussed(long when, AgentId who, ArtifactId id, IEventFilter ev) throws CartagoException {
        try {
            this.logger.artifactFocussed(when, who, id, ev);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void artifactNoMoreFocussed(long when, AgentId who, ArtifactId id) throws CartagoException {
        try {
            this.logger.artifactNoMoreFocussed(when, who, id);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void artifactsLinked(long when, AgentId id, ArtifactId linking, ArtifactId linked) throws CartagoException {
        try {
            this.logger.artifactsLinked(when, id, linking, linked);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void newPercept(long when, ArtifactId aid, Tuple signal, ArtifactObsProperty[] added, ArtifactObsProperty[] removed, ArtifactObsProperty[] changed) throws CartagoException {
        try {
            this.logger.newPercept(when, aid, signal, added, removed, changed);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void opCompleted(long when, OpId id, ArtifactId aid, Op op) throws CartagoException {
        try {
            this.logger.opCompleted(when, id, aid, op);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void opFailed(long when, OpId id, ArtifactId aid, Op op, String msg, Tuple descr) throws CartagoException {
        try {
            this.logger.opFailed(when, id, aid, op, msg, descr);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void opRequested(long when, AgentId who, ArtifactId aid, Op op) throws CartagoException {
        try {
            this.logger.opRequested(when, who, aid, op);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void opResumed(long when, OpId id, ArtifactId aid, Op op) throws CartagoException {
        try {
            this.logger.opResumed(when, id, aid, op);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void opStarted(long when, OpId id, ArtifactId aid, Op op) throws CartagoException {
        try {
            this.logger.opStarted(when, id, aid, op);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public void opSuspended(long when, OpId id, ArtifactId aid, Op op) throws CartagoException {
        try {
            this.logger.opSuspended(when, id, aid, op);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }
}

