/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.rmi;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ICartagoLogger;
import cartago.NodeId;
import cartago.Op;
import cartago.OpId;
import cartago.infrastructure.CartagoInfrastructureLayerException;
import cartago.infrastructure.ICartagoInfrastructureLayer;
import cartago.infrastructure.rmi.AgentBodyProxy;
import cartago.infrastructure.rmi.CartagoCallbackProxy;
import cartago.infrastructure.rmi.CartagoCallbackRemote;
import cartago.infrastructure.rmi.CartagoLoggerProxy;
import cartago.infrastructure.rmi.CartagoLoggerRemote;
import cartago.infrastructure.rmi.CartagoNodeRemote;
import cartago.infrastructure.rmi.ICartagoNodeRemote;
import cartago.infrastructure.rmi.KeepRemoteBodyAliveManagerAgent;
import cartago.security.AgentCredential;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CartagoInfrastructureLayer
implements ICartagoInfrastructureLayer {
    private KeepRemoteBodyAliveManagerAgent keepAliveAgent;
    private ConcurrentLinkedQueue<AgentBodyProxy> remoteCtxs = new ConcurrentLinkedQueue();
    public static final int DEFAULT_PORT = 20100;
    private CartagoNodeRemote service;

    public CartagoInfrastructureLayer() {
        this.keepAliveAgent = new KeepRemoteBodyAliveManagerAgent(this.remoteCtxs, 5000L);
        this.keepAliveAgent.start();
    }

    @Override
    public void shutdownLayer() throws CartagoException {
        this.keepAliveAgent.shutdown();
    }

    @Override
    public ICartagoContext joinRemoteWorkspace(String wspName, String address, AgentCredential cred, ICartagoCallback eventListener) throws CartagoInfrastructureLayerException, CartagoException {
        try {
            String fullAddress = address;
            if (CartagoInfrastructureLayer.getPort(address) == -1) {
                fullAddress = address + ":" + 20100;
            }
            ICartagoNodeRemote env = (ICartagoNodeRemote)Naming.lookup("rmi://" + fullAddress + "/cartago_node");
            CartagoCallbackRemote srv = new CartagoCallbackRemote(eventListener);
            CartagoCallbackProxy proxy = new CartagoCallbackProxy(srv);
            System.out.println("Looking for rmi://" + address + "/cartago_node");
            ICartagoContext ctx = env.join(wspName, cred, proxy);
            this.remoteCtxs.add((AgentBodyProxy)ctx);
            return ctx;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
        catch (NotBoundException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public OpId execRemoteInterArtifactOp(ICartagoCallback callback, long callbackId, AgentId userId, ArtifactId srcId, ArtifactId targetId, String address, Op op, long timeout, IAlignmentTest test) throws CartagoInfrastructureLayerException, CartagoException {
        try {
            CartagoCallbackRemote srv = new CartagoCallbackRemote(callback);
            CartagoCallbackProxy proxy = new CartagoCallbackProxy(srv);
            String fullAddress = address;
            if (CartagoInfrastructureLayer.getPort(address) == -1) {
                fullAddress = address + ":" + 20100;
            }
            ICartagoNodeRemote env = (ICartagoNodeRemote)Naming.lookup("rmi://" + fullAddress + "/cartago_node");
            return env.execInterArtifactOp(proxy, callbackId, userId, srcId, targetId, op, timeout, test);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CartagoException("Inter-artifact op failed: " + ex.getLocalizedMessage());
        }
    }

    @Override
    public NodeId getNodeAt(String address) throws CartagoInfrastructureLayerException, CartagoException {
        try {
            String fullAddress = address;
            if (CartagoInfrastructureLayer.getPort(address) == -1) {
                fullAddress = address + ":" + 20100;
            }
            ICartagoNodeRemote env = (ICartagoNodeRemote)Naming.lookup("rmi://" + fullAddress + "/cartago_node");
            return env.getNodeId();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
        catch (NotBoundException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public void registerLoggerToRemoteWsp(String wspName, String address, ICartagoLogger logger) throws CartagoException {
        try {
            String fullAddress = address;
            if (CartagoInfrastructureLayer.getPort(address) == -1) {
                fullAddress = address + ":" + 20100;
            }
            ICartagoNodeRemote env = (ICartagoNodeRemote)Naming.lookup("rmi://" + fullAddress + "/cartago_node");
            CartagoLoggerRemote srv = new CartagoLoggerRemote(logger);
            CartagoLoggerProxy proxy = new CartagoLoggerProxy(srv);
            env.registerLogger(wspName, proxy);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
        catch (NotBoundException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public void startService(CartagoNode node, String address) throws CartagoInfrastructureLayerException {
        if (this.service != null) {
            throw new CartagoInfrastructureLayerException();
        }
        try {
            int port = 20100;
            this.service = new CartagoNodeRemote(node);
            if (address == null || address.equals("")) {
                address = InetAddress.getLocalHost().getHostAddress();
            } else {
                int port1 = CartagoInfrastructureLayer.getPort(address);
                if (port1 != -1) {
                    port = port1;
                    address = address.substring(0, address.indexOf(58));
                }
            }
            this.service.install(address, port);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public void shutdownService() throws CartagoException {
        if (this.service != null) {
            this.service.shutdownService();
            this.service = null;
        }
    }

    @Override
    public boolean isServiceRunning() {
        return this.service != null;
    }

    private static int getPort(String address) {
        int index = address.indexOf(":");
        if (index != -1) {
            String snum = address.substring(index + 1);
            return Integer.parseInt(snum);
        }
        return -1;
    }
}

