/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.rmi;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.ArtifactInfo;
import cartago.CartagoException;
import cartago.ICartagoController;
import cartago.infrastructure.rmi.ICartagoControllerRemote;
import java.io.Serializable;
import java.rmi.RemoteException;

public class CartagoControllerProxy
implements ICartagoController,
Serializable {
    private ICartagoControllerRemote ctx;

    CartagoControllerProxy(ICartagoControllerRemote ctx) throws CartagoException {
        this.ctx = ctx;
    }

    @Override
    public ArtifactId[] getCurrentArtifacts() throws CartagoException {
        try {
            return this.ctx.getCurrentArtifacts();
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public AgentId[] getCurrentAgents() throws CartagoException {
        try {
            return this.ctx.getCurrentAgents();
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public boolean removeArtifact(String artifactName) throws CartagoException {
        try {
            return this.ctx.removeArtifact(artifactName);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public boolean removeAgent(String id) throws CartagoException {
        try {
            return this.ctx.removeAgent(id);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public ArtifactInfo getArtifactInfo(String name) throws CartagoException {
        try {
            return this.ctx.getArtifactInfo(name);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }
}

