/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.rmi;

import cartago.AgentBody;
import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.IAlignmentTest;
import cartago.Op;
import cartago.WorkspaceId;
import cartago.infrastructure.rmi.IAgentBodyRemote;
import cartago.security.SecurityException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class AgentBodyRemote
extends UnicastRemoteObject
implements IAgentBodyRemote {
    public AgentBody ctx;
    private long lastPingFromMind;

    public AgentBodyRemote() throws SecurityException, RemoteException {
    }

    public AgentBodyRemote(AgentBody ctx) throws SecurityException, RemoteException {
        this.ctx = ctx;
        this.lastPingFromMind = System.currentTimeMillis();
    }

    @Override
    public AgentId getAgentId() throws CartagoException, RemoteException {
        return this.ctx.getAgentId();
    }

    @Override
    public WorkspaceId getWorkspaceId() throws SecurityException, RemoteException, CartagoException {
        return this.ctx.getWorkspaceId();
    }

    @Override
    public void doAction(long agentCallbackId, ArtifactId id, Op op, IAlignmentTest test, long timeout) throws RemoteException, CartagoException {
        this.ctx.doAction(agentCallbackId, id, op, test, timeout);
    }

    @Override
    public boolean doAction(long agentCallbackId, String name, Op op, IAlignmentTest test, long timeout) throws RemoteException, CartagoException {
        return this.ctx.doAction(agentCallbackId, name, op, test, timeout);
    }

    @Override
    public boolean doAction(long agentCallbackId, Op op, IAlignmentTest test, long timeout) throws RemoteException, CartagoException {
        return this.ctx.doAction(agentCallbackId, op, test, timeout);
    }

    @Override
    public synchronized void ping() throws RemoteException {
        this.lastPingFromMind = System.currentTimeMillis();
    }

    synchronized long getLastPing() {
        return this.lastPingFromMind;
    }

    AgentBody getContext() {
        return this.ctx;
    }
}

