/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.rmi;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.IAlignmentTest;
import cartago.ICartagoContext;
import cartago.Op;
import cartago.WorkspaceId;
import cartago.infrastructure.rmi.IAgentBodyRemote;
import java.io.Serializable;
import java.rmi.RemoteException;

public class AgentBodyProxy
implements ICartagoContext,
Serializable {
    private IAgentBodyRemote ctx;
    private WorkspaceId wspId;

    AgentBodyProxy(IAgentBodyRemote ctx) throws CartagoException {
        this.ctx = ctx;
        try {
            this.wspId = ctx.getWorkspaceId();
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public AgentId getAgentId() throws CartagoException {
        try {
            return this.ctx.getAgentId();
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public WorkspaceId getWorkspaceId() throws CartagoException {
        return this.wspId;
    }

    @Override
    public void doAction(long agentCallbackId, ArtifactId id, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        try {
            this.ctx.doAction(agentCallbackId, id, op, test, timeout);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public boolean doAction(long agentCallbackId, String id, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        try {
            return this.ctx.doAction(agentCallbackId, id, op, test, timeout);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    @Override
    public boolean doAction(long agentCallbackId, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        try {
            return this.ctx.doAction(agentCallbackId, op, test, timeout);
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }

    public void ping() throws CartagoException {
        try {
            this.ctx.ping();
        }
        catch (RemoteException ex) {
            throw new CartagoException(ex.getMessage());
        }
    }
}

