/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.lipermi;

import cartago.infrastructure.lipermi.AgentBodyRemote;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

class GarbageBodyCollectorAgent
extends Thread {
    private ConcurrentLinkedQueue<AgentBodyRemote> remoteCtxs;
    private boolean stopped;
    private long delay;
    private long timeout;

    public GarbageBodyCollectorAgent(ConcurrentLinkedQueue<AgentBodyRemote> contexts, long delay, long timeout) {
        this.setName("GarbageBodyCollectorAgentLipeRMI");
        this.delay = delay;
        this.remoteCtxs = contexts;
        this.timeout = timeout;
    }

    public synchronized void stopActivity() {
        this.stopped = true;
        this.interrupt();
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void run() {
        this.stopped = false;
        while (!this.isStopped()) {
            try {
                GarbageBodyCollectorAgent.sleep(this.delay);
                Iterator<AgentBodyRemote> it = this.remoteCtxs.iterator();
                while (it.hasNext()) {
                    AgentBodyRemote ctx = it.next();
                    try {
                        long last = ctx.getLastPing();
                        if (System.currentTimeMillis() - last <= this.timeout) continue;
                        ctx.getContext().getWSPKernel().removeGarbageBody(ctx.getContext());
                        ctx.invalidateObject();
                        it.remove();
                        this.log("body garbaged: " + ctx.getContext().getAgentId());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void log(String msg) {
        System.out.println("[GarbageBody Collector] " + msg);
    }
}

