/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.lipermi;

import cartago.AgentBody;
import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CARTAGO_VERSION;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.CartagoWorkspace;
import cartago.IAlignmentTest;
import cartago.ICartagoContext;
import cartago.NodeId;
import cartago.Op;
import cartago.OpId;
import cartago.infrastructure.lipermi.AgentBodyRemote;
import cartago.infrastructure.lipermi.CartagoCallbackProxy;
import cartago.infrastructure.lipermi.GarbageBodyCollectorAgent;
import cartago.infrastructure.lipermi.IAgentBodyRemote;
import cartago.infrastructure.lipermi.ICartagoCallbackRemote;
import cartago.infrastructure.lipermi.ICartagoNodeRemote;
import cartago.security.AgentCredential;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import lipermi.exception.LipeRMIException;
import lipermi.handler.CallHandler;
import lipermi.net.Server;

public class CartagoNodeRemote
implements ICartagoNodeRemote {
    private int mPort;
    private CartagoNode mNode;
    private ConcurrentLinkedQueue<AgentBodyRemote> mRemoteCtxs;
    private GarbageBodyCollectorAgent mGarbageCollector;
    private CallHandler mCallHandler;
    private Server mServer;

    public CartagoNodeRemote(CartagoNode node) {
        this.mNode = node;
        this.mRemoteCtxs = new ConcurrentLinkedQueue();
        this.mGarbageCollector = new GarbageBodyCollectorAgent(this.mRemoteCtxs, 500L, 10000L);
        this.mGarbageCollector.start();
    }

    public void install(int port) throws Exception {
        this.mPort = port;
        this.mCallHandler = new CallHandler();
        this.mServer = new Server();
        try {
            this.mCallHandler.registerGlobal(ICartagoNodeRemote.class, (Object)this);
        }
        catch (LipeRMIException e) {
            e.printStackTrace();
        }
        try {
            this.mServer.bind(this.mPort, this.mCallHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("CArtAgO LipeRMI Service installed on port: " + this.mPort);
    }

    public void shutdownService() {
        this.mGarbageCollector.stopActivity();
        this.mServer.close();
    }

    public int getPort() {
        return this.mPort;
    }

    @Override
    public OpId execInterArtifactOp(ICartagoCallbackRemote callback, long callbackId, AgentId userId, ArtifactId srcId, ArtifactId targetId, Op op, long timeout, IAlignmentTest test) throws CartagoException {
        CartagoCallbackProxy proxy = new CartagoCallbackProxy(callback);
        String wspName = targetId.getWorkspaceId().getName();
        CartagoWorkspace wsp = this.mNode.getWorkspace(wspName);
        return wsp.execInterArtifactOp(proxy, callbackId, userId, srcId, targetId, op, timeout, test);
    }

    @Override
    public String getVersion() throws CartagoException {
        return CARTAGO_VERSION.getID();
    }

    @Override
    public IAgentBodyRemote join(String wspName, AgentCredential cred, ICartagoCallbackRemote callback) throws CartagoException {
        CartagoWorkspace wsp = this.mNode.getWorkspace(wspName);
        CartagoCallbackProxy proxy = new CartagoCallbackProxy(callback);
        ICartagoContext ctx = wsp.join(cred, proxy);
        try {
            AgentBodyRemote rctx = new AgentBodyRemote((AgentBody)ctx, this.mCallHandler);
            this.mRemoteCtxs.add(rctx);
            return rctx;
        }
        catch (LipeRMIException e) {
            e.printStackTrace();
            throw new CartagoException(e.getLocalizedMessage());
        }
    }

    @Override
    public void quit(String wspName, AgentId id) throws CartagoException {
        CartagoWorkspace wsp = this.mNode.getWorkspace(wspName);
        wsp.getKernel().quitAgent(id);
        Iterator<AgentBodyRemote> it = this.mRemoteCtxs.iterator();
        while (it.hasNext()) {
            AgentBodyRemote c = it.next();
            if (!c.getAgentId().equals(id)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public NodeId getNodeId() throws CartagoException {
        return CartagoNode.getInstance().getId();
    }
}

