/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.lipermi;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ICartagoLogger;
import cartago.NodeId;
import cartago.Op;
import cartago.OpId;
import cartago.infrastructure.CartagoInfrastructureLayerException;
import cartago.infrastructure.ICartagoInfrastructureLayer;
import cartago.infrastructure.lipermi.AgentBodyProxy;
import cartago.infrastructure.lipermi.CartagoCallbackRemote;
import cartago.infrastructure.lipermi.CartagoNodeRemote;
import cartago.infrastructure.lipermi.IAgentBodyRemote;
import cartago.infrastructure.lipermi.ICartagoNodeRemote;
import cartago.infrastructure.lipermi.KeepRemoteBodyAliveManagerAgent;
import cartago.security.AgentCredential;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import lipermi.exception.LipeRMIException;
import lipermi.handler.CallHandler;
import lipermi.net.Client;

public class CartagoInfrastructureLayer
implements ICartagoInfrastructureLayer {
    public static final int DEFAULT_PORT = 20101;
    private KeepRemoteBodyAliveManagerAgent mKeepAliveAgent;
    private ConcurrentLinkedQueue<AgentBodyProxy> mRemoteCtxs = new ConcurrentLinkedQueue();
    private CartagoNodeRemote mService;

    public CartagoInfrastructureLayer() {
        this.mKeepAliveAgent = new KeepRemoteBodyAliveManagerAgent(this.mRemoteCtxs, 500L);
        this.mKeepAliveAgent.start();
    }

    @Override
    public OpId execRemoteInterArtifactOp(ICartagoCallback callback, long callbackId, AgentId userId, ArtifactId srcId, ArtifactId targetId, String fullAddress, Op op, long timeout, IAlignmentTest test) throws CartagoInfrastructureLayerException, CartagoException {
        try {
            CallHandler callHandler = new CallHandler();
            CartagoCallbackRemote srv = new CartagoCallbackRemote(callback, callHandler);
            String address = CartagoInfrastructureLayer.getAddress(fullAddress);
            int port = 20101;
            int port1 = CartagoInfrastructureLayer.getPort(fullAddress);
            if (port1 != -1) {
                port = port1;
            }
            Client client = new Client(address, port, callHandler);
            ICartagoNodeRemote env = (ICartagoNodeRemote)client.getGlobal(ICartagoNodeRemote.class);
            return env.execInterArtifactOp(srv, callbackId, userId, srcId, targetId, op, timeout, test);
        }
        catch (LipeRMIException e) {
            e.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public NodeId getNodeAt(String fullAddress) throws CartagoInfrastructureLayerException, CartagoException {
        try {
            CallHandler callHandler = new CallHandler();
            String address = CartagoInfrastructureLayer.getAddress(fullAddress);
            int port = 20101;
            int port1 = CartagoInfrastructureLayer.getPort(fullAddress);
            if (port1 != -1) {
                port = port1;
            }
            Client client = new Client(address, port, callHandler);
            ICartagoNodeRemote env = (ICartagoNodeRemote)client.getGlobal(ICartagoNodeRemote.class);
            NodeId nodeId = env.getNodeId();
            client.close();
            return nodeId;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public boolean isServiceRunning() {
        return this.mService != null;
    }

    @Override
    public ICartagoContext joinRemoteWorkspace(String wspName, String fullAddress, AgentCredential cred, ICartagoCallback eventListener) throws CartagoInfrastructureLayerException, CartagoException {
        try {
            CallHandler callHandler = new CallHandler();
            CartagoCallbackRemote srv = new CartagoCallbackRemote(eventListener, callHandler);
            String address = CartagoInfrastructureLayer.getAddress(fullAddress);
            int port = 20101;
            int port1 = CartagoInfrastructureLayer.getPort(fullAddress);
            if (port1 != -1) {
                port = port1;
            }
            Client client = new Client(address, port, callHandler);
            ICartagoNodeRemote env = (ICartagoNodeRemote)client.getGlobal(ICartagoNodeRemote.class);
            IAgentBodyRemote rctx = env.join(wspName, cred, srv);
            AgentBodyProxy ctx = new AgentBodyProxy(rctx, client);
            this.mRemoteCtxs.add(ctx);
            return ctx;
        }
        catch (IOException ex) {
            throw new CartagoInfrastructureLayerException();
        }
        catch (LipeRMIException e) {
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public void shutdownLayer() throws CartagoException {
        this.mKeepAliveAgent.shutdown();
    }

    @Override
    public void shutdownService() throws CartagoException {
        if (this.mService != null) {
            this.mService.shutdownService();
            this.mService = null;
        }
    }

    @Override
    public void startService(CartagoNode node, String address) throws CartagoInfrastructureLayerException {
        if (this.mService != null) {
            throw new CartagoInfrastructureLayerException();
        }
        try {
            int port = 20101;
            this.mService = new CartagoNodeRemote(node);
            if (address != null && !address.equals("")) {
                port = Integer.parseInt(address);
            }
            this.mService.install(port);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CartagoInfrastructureLayerException();
        }
    }

    @Override
    public void registerLoggerToRemoteWsp(String wspName, String address, ICartagoLogger logger) throws CartagoException {
        throw new CartagoException("Feature not supported (TODO)");
    }

    private static String getAddress(String address) {
        int index = address.indexOf(":");
        if (index == -1) {
            return address;
        }
        return address.substring(0, index);
    }

    private static int getPort(String address) {
        int index = address.indexOf(":");
        if (index != -1) {
            return Integer.parseInt(address.substring(index + 1));
        }
        return -1;
    }
}

