/*
 * Decompiled with CFR 0.152.
 */
package cartago.infrastructure.lipermi;

import cartago.AgentBody;
import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.IAlignmentTest;
import cartago.Op;
import cartago.WorkspaceId;
import cartago.infrastructure.lipermi.IAgentBodyRemote;
import lipermi.exception.LipeRMIException;
import lipermi.handler.CallHandler;

public class AgentBodyRemote
implements IAgentBodyRemote {
    private static final long serialVersionUID = 1L;
    private AgentBody mCtx;
    private long mLastPingFromMind;
    private CallHandler mCallHandler;

    public AgentBodyRemote(AgentBody ctx, CallHandler callHandler) throws LipeRMIException {
        this.mCtx = ctx;
        this.mLastPingFromMind = System.currentTimeMillis();
        this.mCallHandler = callHandler;
        this.mCallHandler.exportObject(IAgentBodyRemote.class, (Object)this);
    }

    @Override
    public void doAction(long actionId, ArtifactId id, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        this.mCtx.doAction(actionId, id, op, test, timeout);
    }

    @Override
    public boolean doAction(long actionId, String name, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        return this.mCtx.doAction(actionId, name, op, test, timeout);
    }

    @Override
    public boolean doAction(long actionId, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        return this.mCtx.doAction(actionId, op, test, timeout);
    }

    @Override
    public AgentId getAgentId() throws CartagoException {
        return this.mCtx.getAgentId();
    }

    @Override
    public WorkspaceId getWorkspaceId() throws CartagoException {
        return this.mCtx.getWorkspaceId();
    }

    @Override
    public synchronized void ping() {
        this.mLastPingFromMind = System.currentTimeMillis();
    }

    public synchronized long getLastPing() {
        return this.mLastPingFromMind;
    }

    public AgentBody getContext() {
        return this.mCtx;
    }

    public void invalidateObject() {
    }
}

