/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AbstractArtifactAdapter;
import cartago.AbstractWSPRuleEngine;
import cartago.AbstractWorkspacePoint;
import cartago.AbstractWorkspaceTopology;
import cartago.AgentBody;
import cartago.AgentBodyArtifact;
import cartago.AgentId;
import cartago.AgentJoinRequestInfo;
import cartago.AgentQuitRequestInfo;
import cartago.Artifact;
import cartago.ArtifactAlreadyPresentException;
import cartago.ArtifactConfig;
import cartago.ArtifactConfigurationFailedException;
import cartago.ArtifactDescriptor;
import cartago.ArtifactFactory;
import cartago.ArtifactId;
import cartago.ArtifactInfo;
import cartago.ArtifactNotAvailableException;
import cartago.ArtifactObsProperty;
import cartago.CartagoException;
import cartago.CartagoLoggerManager;
import cartago.DefaultArtifactFactory;
import cartago.EventRegistry;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ICartagoController;
import cartago.ICartagoLogger;
import cartago.ICartagoLoggerManager;
import cartago.IEventFilter;
import cartago.InvalidManualException;
import cartago.Manual;
import cartago.ManualNotAvailableException;
import cartago.NoArtifactException;
import cartago.ObservableArtifactInfo;
import cartago.Op;
import cartago.OpDescriptor;
import cartago.OpExecutionFrame;
import cartago.OpId;
import cartago.OpRequestInfo;
import cartago.OpRequestTimeoutException;
import cartago.OperationUnavailableException;
import cartago.Tuple;
import cartago.UnknownArtifactException;
import cartago.UnknownArtifactTemplateException;
import cartago.WorkspaceId;
import cartago.events.ActionFailedEvent;
import cartago.events.ActionSucceededEvent;
import cartago.events.ArtifactObsEvent;
import cartago.events.ConsultManualSucceededEvent;
import cartago.events.FocusSucceededEvent;
import cartago.events.FocussedArtifactDisposedEvent;
import cartago.events.JoinWSPSucceededEvent;
import cartago.events.ObsArtListChangedEvent;
import cartago.events.QuitWSPSucceededEvent;
import cartago.events.StopFocusSucceededEvent;
import cartago.security.AgentCredential;
import cartago.security.IWorkspaceSecurityManager;
import cartago.security.NullSecurityManager;
import cartago.security.SecurityException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkspaceKernel {
    private static final int NCONTROLLERS_DEFAULT = 20;
    private WorkspaceId id;
    private AtomicInteger artifactIds;
    private int ctxIds;
    private HashMap<String, AgentBody> joinedAgents;
    private HashMap<String, ArtifactDescriptor> artifactMap;
    private HashMap<String, List<ArtifactDescriptor>> opMap;
    private HashMap<String, Manual> artManuals;
    private ArrayList<EnvironmentController> controllers;
    private int nBusyControllers;
    private ArrayBlockingQueue<OpExecutionFrame> opTodo;
    private AgentBody wspManager;
    private ICartagoLoggerManager logManager;
    private EventRegistry eventRegistry;
    private boolean isShutdown;
    private IWorkspaceSecurityManager securityManager;
    private final IWorkspaceSecurityManager DEFAULT_SECURITY_MANAGER = new NullSecurityManager();
    private final ICartagoLoggerManager DEFAULT_LOGGER_MANAGER = new CartagoLoggerManager();
    private LinkedList<ArtifactFactory> artifactFactories;
    private AbstractWSPRuleEngine wspRuleEngine;
    private AbstractWorkspaceTopology topology;

    WorkspaceKernel(WorkspaceId id, ICartagoLogger logger) {
        this.id = id;
        this.wspRuleEngine = null;
        this.isShutdown = false;
        this.eventRegistry = new EventRegistry();
        this.joinedAgents = new HashMap();
        this.artifactMap = new HashMap();
        this.opMap = new HashMap();
        this.artManuals = new HashMap();
        this.opTodo = new ArrayBlockingQueue(100);
        this.artifactIds = new AtomicInteger(0);
        this.artifactFactories = new LinkedList();
        this.artifactFactories.addFirst(new DefaultArtifactFactory());
        this.ctxIds = 0;
        this.wspManager = new AgentBody(new AgentId("workspace-manager", UUID.randomUUID().toString(), this.ctxIds++, "WorkspaceManager", id), this, null);
        this.securityManager = this.DEFAULT_SECURITY_MANAGER;
        this.logManager = this.DEFAULT_LOGGER_MANAGER;
        this.nBusyControllers = 0;
        this.controllers = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            EnvironmentController controller = new EnvironmentController(this, this.opTodo);
            this.controllers.add(controller);
            controller.start();
        }
        if (logger != null) {
            this.logManager.registerLogger(logger);
        }
        try {
            this.makeArtifact(this.wspManager.getAgentId(), "workspace", "cartago.WorkspaceArtifact", new ArtifactConfig(this));
            this.makeArtifact(this.wspManager.getAgentId(), "node", "cartago.NodeArtifact", new ArtifactConfig(this));
            this.makeArtifact(this.wspManager.getAgentId(), "manrepo", "cartago.ManRepoArtifact", new ArtifactConfig(this));
            this.makeArtifact(this.wspManager.getAgentId(), "console", "cartago.tools.Console", ArtifactConfig.DEFAULT_CONFIG);
            this.makeArtifact(this.wspManager.getAgentId(), "blackboard", "cartago.tools.TupleSpace", ArtifactConfig.DEFAULT_CONFIG);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public WorkspaceId getId() {
        return this.id;
    }

    ICartagoContext getWSPManager() {
        return this.wspManager;
    }

    public void setSecurityManager(IWorkspaceSecurityManager man) {
        this.securityManager = man;
    }

    public IWorkspaceSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setLoggerManager(ICartagoLoggerManager man) {
        this.logManager = man;
    }

    public ICartagoLoggerManager getLoggerManager() {
        return this.logManager;
    }

    public ICartagoContext joinWorkspace(AgentCredential cred, ICartagoCallback eventListener) throws CartagoException {
        String roleName = cred.getRoleName();
        if (roleName == null || roleName.equals("")) {
            roleName = this.securityManager.getDefaultRoleName();
        }
        HashMap<String, AgentBody> hashMap = this.joinedAgents;
        synchronized (hashMap) {
            AgentBody context = this.joinedAgents.get(cred.getGlobalId());
            if (context != null) {
                throw new SecurityException("Agent " + cred.getGlobalId() + " already joined " + this.getId());
            }
            ++this.ctxIds;
            AgentId userId = new AgentId(cred.getId(), cred.getGlobalId(), this.ctxIds, roleName, this.id);
            boolean joinOK = true;
            String failureMsg = "no msg";
            if (this.wspRuleEngine != null) {
                AgentJoinRequestInfo req = new AgentJoinRequestInfo(userId);
                this.wspRuleEngine.processAgentJoinRequest(req);
                if (req.isFailed()) {
                    joinOK = false;
                    failureMsg = req.getFailureMsg();
                }
            }
            if (joinOK) {
                context = new AgentBody(userId, this, eventListener);
                this.joinedAgents.put(userId.getGlobalId(), context);
                ArtifactId bodyId = this.makeAgentBodyArtifact(context);
                List<ArtifactObsProperty> props = this.focus(userId, null, eventListener, bodyId);
                this.notifyFocusCompleted(eventListener, -1L, null, null, bodyId, props);
                long time = System.currentTimeMillis();
                if (this.logManager.isLogging()) {
                    this.logManager.agentJoined(time, userId);
                }
                return context;
            }
            throw new CartagoException(failureMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArtifactId makeAgentBodyArtifact(AgentBody body) {
        try {
            String name = body.getAgentId().getAgentName() + "-body";
            ArtifactId id = this.makeArtifact(this.wspManager.getAgentId(), name, "cartago.AgentBodyArtifact", new ArtifactConfig(body));
            ArtifactDescriptor des = null;
            HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
            synchronized (hashMap) {
                des = this.artifactMap.get(name);
                body.setBodyArtifact((AgentBodyArtifact)des.getArtifact());
            }
            return id;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindAgentBodyArtifact(AgentId agentId, AgentBodyArtifact art) {
        HashMap<String, AgentBody> hashMap = this.joinedAgents;
        synchronized (hashMap) {
            AgentBody body = this.joinedAgents.get(agentId.getGlobalId());
            if (body != null) {
                body.setBodyArtifact(art);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactId getAgentBodyArtifact(AgentId agentId) {
        HashMap<String, AgentBody> hashMap = this.joinedAgents;
        synchronized (hashMap) {
            AgentBody body = this.joinedAgents.get(agentId.getGlobalId());
            if (body != null) {
                return body.getAgentBodyArtifact().getId();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAgentPositionOrRadiusChange(AgentId agentId) throws CartagoException {
        if (this.topology != null) {
            AgentBody body = null;
            HashMap<String, AgentBody> hashMap = this.joinedAgents;
            synchronized (hashMap) {
                body = this.joinedAgents.get(agentId.getGlobalId());
            }
            if (body != null) {
                LinkedList<ObservableArtifactInfo> newFocused = new LinkedList<ObservableArtifactInfo>();
                LinkedList<ObservableArtifactInfo> noMoreFocused = new LinkedList<ObservableArtifactInfo>();
                ArrayList<ObservableArtifactInfo> obsArtifactInfoList = new ArrayList<ObservableArtifactInfo>();
                AgentId userId = body.getAgentId();
                ICartagoCallback callback = body.getCallback();
                double observingRadius = body.getAgentBodyArtifact().getObservingRadius();
                AbstractWorkspacePoint agentPos = body.getAgentBodyArtifact().getPosition();
                HashMap<String, ArtifactDescriptor> hashMap2 = this.artifactMap;
                synchronized (hashMap2) {
                    for (ArtifactDescriptor des : this.artifactMap.values()) {
                        Artifact art = des.getArtifact();
                        AbstractWorkspacePoint arPos = art.getPosition();
                        if (arPos == null) continue;
                        double distance = this.topology.getDistance(agentPos, arPos);
                        if (distance < observingRadius && distance < art.getObservabilityRadius()) {
                            List<ArtifactObsProperty> obs = des.getAdapter().readProperties();
                            des.addObserver(userId, null, callback);
                            obsArtifactInfoList.add(new ObservableArtifactInfo(des, obs));
                            continue;
                        }
                        des.removeObserver(userId);
                    }
                }
                body.updateObsArtifactListWith(obsArtifactInfoList, noMoreFocused, newFocused);
                ObsArtListChangedEvent ev = this.eventRegistry.makeObsArtListChangedEvent(newFocused, noMoreFocused);
                callback.notifyCartagoEvent(ev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyArtifactPositionOrRadiusChange(ArtifactId id) throws CartagoException {
        if (this.topology != null) {
            ArtifactDescriptor des = null;
            HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
            synchronized (hashMap) {
                des = this.artifactMap.get(id.getName());
            }
            if (des != null) {
                AbstractWorkspacePoint artifactPos = des.getArtifact().getPosition();
                HashMap<String, AgentBody> hashMap2 = this.joinedAgents;
                synchronized (hashMap2) {
                    double observabilityRadius = des.getAdapter().getObservabilityRadius();
                    for (AgentBody ag : this.joinedAgents.values()) {
                        List<ArtifactObsProperty> obs;
                        AgentBodyArtifact ar = ag.getAgentBodyArtifact();
                        if (ar == null) continue;
                        LinkedList<ObservableArtifactInfo> newFocused = new LinkedList<ObservableArtifactInfo>();
                        LinkedList<ObservableArtifactInfo> noMoreFocused = new LinkedList<ObservableArtifactInfo>();
                        double distance = this.topology.getDistance(ar.getPosition(), artifactPos);
                        if (distance < observabilityRadius && distance < ar.getObservingRadius()) {
                            if (!ag.isObserving(id)) {
                                ag.addFocusedArtifacts(des);
                                obs = des.getAdapter().readProperties();
                                des.addObserver(ag.getAgentId(), null, ag.getCallback());
                                newFocused.add(new ObservableArtifactInfo(des, obs));
                            }
                        } else if (ag.isObserving(id)) {
                            ag.removeFocusedArtifacts(des);
                            obs = des.getAdapter().readProperties();
                            des.removeObserver(ag.getAgentId());
                            noMoreFocused.add(new ObservableArtifactInfo(des, obs));
                        }
                        if (newFocused.size() <= 0 && noMoreFocused.size() <= 0) continue;
                        ObsArtListChangedEvent ev = this.eventRegistry.makeObsArtListChangedEvent(newFocused, noMoreFocused);
                        ag.getCallback().notifyCartagoEvent(ev);
                    }
                }
            }
        }
    }

    public void setWSPTopology(AbstractWorkspaceTopology topology) {
        this.topology = topology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quitAgent(AgentId userId) throws CartagoException {
        boolean quitOk = true;
        String failureMsg = "no msg";
        if (this.wspRuleEngine != null) {
            AgentQuitRequestInfo req = new AgentQuitRequestInfo(userId);
            this.wspRuleEngine.processAgentQuitRequest(req);
            if (req.isFailed()) {
                quitOk = false;
                failureMsg = req.getFailureMsg();
            }
        }
        if (quitOk) {
            HashMap<String, Object> hashMap = this.joinedAgents;
            synchronized (hashMap) {
                AgentBody body = this.joinedAgents.remove(userId.getGlobalId());
                if (body == null) {
                    throw new CartagoException("User not in workspace.");
                }
                if (body.getAgentBodyArtifact() != null) {
                    List<ArtifactObsProperty> props = this.stopFocus(userId, body.getCallback(), body.getAgentBodyArtifact().getId());
                    this.notifyStopFocusCompleted(body.getCallback(), -1L, null, null, body.getAgentBodyArtifact().getId(), props);
                    this.disposeArtifact(userId, body.getAgentBodyArtifact().getId());
                }
                long time = System.currentTimeMillis();
                if (this.logManager.isLogging()) {
                    this.logManager.agentQuit(time, userId);
                }
            }
            hashMap = this.artifactMap;
            synchronized (hashMap) {
                for (ArtifactDescriptor des : this.artifactMap.values()) {
                    des.removeObserver(userId);
                }
            }
        }
        throw new CartagoException(failureMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArtifactFactory(ArtifactFactory factory) {
        LinkedList<ArtifactFactory> linkedList = this.artifactFactories;
        synchronized (linkedList) {
            this.artifactFactories.addFirst(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeArtifactFactory(String name) {
        LinkedList<ArtifactFactory> linkedList = this.artifactFactories;
        synchronized (linkedList) {
            Iterator it = this.artifactFactories.iterator();
            while (it.hasNext()) {
                ArtifactFactory cl = (ArtifactFactory)it.next();
                if (!cl.getName().equals(name)) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactId makeArtifact(AgentId userId, String name, String template, ArtifactConfig config) throws ArtifactAlreadyPresentException, UnknownArtifactTemplateException, ArtifactConfigurationFailedException {
        ArtifactId id = null;
        AbstractArtifactAdapter adapter = null;
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(name);
            if (des != null) {
                throw new ArtifactAlreadyPresentException(name, this.id.getName());
            }
        }
        Artifact artifact = this.makeArtifact(template);
        try {
            int freshid = this.artifactIds.incrementAndGet();
            id = new ArtifactId(name, freshid, template, this.id, userId);
            artifact.bind(id, userId, this);
            adapter = artifact.getAdapter();
            ArtifactDescriptor desc = new ArtifactDescriptor(artifact, userId, adapter);
            HashMap<String, ArtifactDescriptor> hashMap2 = this.artifactMap;
            synchronized (hashMap2) {
                this.artifactMap.put(name, desc);
            }
            try {
                adapter.initArtifact(config);
                List<OpDescriptor> ops = desc.getAdapter().getOperations();
                HashMap<String, List<ArtifactDescriptor>> hashMap3 = this.opMap;
                synchronized (hashMap3) {
                    for (OpDescriptor op : ops) {
                        List<ArtifactDescriptor> list = this.opMap.get(op.getKeyId());
                        if (list == null) {
                            list = new ArrayList<ArtifactDescriptor>();
                        }
                        list.add(desc);
                        this.opMap.put(op.getKeyId(), list);
                    }
                }
                if (this.logManager.isLogging()) {
                    this.logManager.artifactCreated(System.currentTimeMillis(), id, userId);
                }
                return id;
            }
            catch (Exception ex) {
                HashMap<String, ArtifactDescriptor> hashMap4 = this.artifactMap;
                synchronized (hashMap4) {
                    this.artifactMap.remove(name);
                }
                throw new ArtifactConfigurationFailedException(template);
            }
        }
        catch (Exception ex) {
            throw new ArtifactConfigurationFailedException(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Artifact makeArtifact(String template) throws UnknownArtifactTemplateException {
        LinkedList<ArtifactFactory> linkedList = this.artifactFactories;
        synchronized (linkedList) {
            for (ArtifactFactory factory : this.artifactFactories) {
                try {
                    return factory.createArtifact(template);
                }
                catch (Exception exception) {
                }
            }
        }
        throw new UnknownArtifactTemplateException("template: " + template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeArtifact(AgentId uid, ArtifactId id) throws CartagoException {
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.remove(id.getName());
            if (des == null) {
                throw new ArtifactNotAvailableException();
            }
            HashMap<String, List<ArtifactDescriptor>> hashMap2 = this.opMap;
            synchronized (hashMap2) {
                Iterator<List<ArtifactDescriptor>> it = this.opMap.values().iterator();
                while (it.hasNext()) {
                    List<ArtifactDescriptor> descList = it.next();
                    Iterator<ArtifactDescriptor> it2 = descList.iterator();
                    while (it2.hasNext()) {
                        ArtifactDescriptor desc = it2.next();
                        if (!desc.getArtifact().getId().equals(id)) continue;
                        it2.remove();
                    }
                    if (!descList.isEmpty()) continue;
                    it.remove();
                }
            }
        }
        try {
            List<ArtifactObsProperty> obs = des.getAdapter().readProperties();
            FocussedArtifactDisposedEvent ev = this.eventRegistry.makeFocussedArtifactDisposedEvent(id, obs);
            des.notifyObservers(ev);
            if (this.logManager.isLogging()) {
                this.logManager.artifactDisposed(System.currentTimeMillis(), id, uid);
            }
            des.getArtifact().dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getArtifactList() {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            Set<Map.Entry<String, ArtifactDescriptor>> set = this.artifactMap.entrySet();
            LinkedList<String> list = new LinkedList<String>();
            for (Map.Entry<String, ArtifactDescriptor> e : set) {
                list.add(e.getKey());
            }
            String[] ids = new String[list.size()];
            ids = list.toArray(ids);
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactId[] getArtifactIdList() {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            Set<Map.Entry<String, ArtifactDescriptor>> set = this.artifactMap.entrySet();
            LinkedList<ArtifactId> list = new LinkedList<ArtifactId>();
            for (Map.Entry<String, ArtifactDescriptor> e : set) {
                list.add(e.getValue().getArtifact().getId());
            }
            ArtifactId[] ids = new ArtifactId[list.size()];
            ids = list.toArray(ids);
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isArtifactPresent(String name) {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            return this.artifactMap.get(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactId lookupArtifact(AgentId userId, String name) throws UnknownArtifactException, ArtifactNotAvailableException {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            ArtifactDescriptor des = this.artifactMap.get(name);
            if (des == null) {
                throw new ArtifactNotAvailableException();
            }
            return des.getArtifact().getId();
        }
    }

    public ArtifactId lookupArtifactByType(AgentId userId, String type) throws UnknownArtifactException, ArtifactNotAvailableException {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            for (ArtifactDescriptor des : this.artifactMap.values()) {
                if (!des.getArtifactType().equals(type)) continue;
                return des.getArtifact().getId();
            }
            throw new ArtifactNotAvailableException();
        }
    }

    public void execOp(long actionId, AgentId userId, ICartagoCallback ctx, ArtifactId aid, Op op, long timeout, IAlignmentTest test) throws CartagoException {
        this.execOp(actionId, userId, ctx, aid, null, op, timeout, test);
    }

    public boolean execOp(long actionId, AgentId userId, ICartagoCallback ctx, String name, Op op, long timeout, IAlignmentTest test) throws CartagoException {
        return this.execOp(actionId, userId, ctx, null, name, op, timeout, test);
    }

    public boolean execOp(long actionId, AgentId userId, ICartagoCallback ctx, Op op, long timeout, IAlignmentTest test) throws CartagoException {
        return this.execOp(actionId, userId, ctx, null, null, op, timeout, test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOp(long actionId, AgentId userId, ICartagoCallback ctx, ArtifactId arId, String arName, Op op, long timeout, IAlignmentTest test) throws CartagoException {
        ActionFailedEvent ev;
        OpId oid;
        if (this.isShutdown) {
            throw new CartagoException("Workspace shutdown.");
        }
        String name = arName;
        if (arId != null) {
            name = arId.getName();
        }
        ArtifactDescriptor des = null;
        if (name != null) {
            HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
            synchronized (hashMap) {
                des = this.artifactMap.get(name);
                if (des == null) {
                    try {
                        ActionFailedEvent ev2 = this.eventRegistry.makeActionFailedEvent(actionId, "Artifact Not Available", new Tuple("artifact_not_available", name), op);
                        ctx.notifyCartagoEvent(ev2);
                        return false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new CartagoException("exec op exception.");
                    }
                }
            }
        }
        ArtifactId aid = null;
        HashMap<String, List<ArtifactDescriptor>> ex = this.opMap;
        synchronized (ex) {
            Iterator<ArtifactDescriptor> opsign;
            List<ArtifactDescriptor> list = this.opMap.get(Artifact.getOpKey(op.getName(), op.getParamValues().length));
            if (list == null && (list = this.opMap.get(opsign = Artifact.getOpKey(op.getName(), -1))) == null) {
                try {
                    ActionFailedEvent ev3 = this.eventRegistry.makeActionFailedEvent(actionId, "Artifact Not Available", new Tuple("artifact_not_available", aid), op);
                    ctx.notifyCartagoEvent(ev3);
                    return false;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    throw new CartagoException("exec op exception.");
                }
            }
            if (list.size() == 1) {
                des = list.get(0);
            } else {
                for (ArtifactDescriptor desc : list) {
                    if (!desc.getAgentCreator().equals(userId)) continue;
                    des = desc;
                    break;
                }
                if (des == null) {
                    for (ArtifactDescriptor desc : list) {
                        if (!desc.isObservedBy(userId)) continue;
                        des = desc;
                        break;
                    }
                }
                if (des == null) {
                    des = list.get(0);
                }
            }
            if (des == null) {
                try {
                    ActionFailedEvent ev4 = this.eventRegistry.makeActionFailedEvent(actionId, "Artifact Not Available", new Tuple("artifact_not_available", aid), op);
                    ctx.notifyCartagoEvent(ev4);
                    return false;
                }
                catch (Exception ex3) {
                    ex3.printStackTrace();
                    throw new CartagoException("exec op exception.");
                }
            }
        }
        aid = des.getArtifact().getId();
        if (this.logManager.isLogging()) {
            this.logManager.opRequested(System.currentTimeMillis(), userId, aid, op);
        }
        if (this.wspRuleEngine == null) {
            boolean allowed = this.securityManager.canDoAction(userId, aid, op);
            if (allowed) {
                oid = des.getAdapter().getFreshId(op.getName(), userId);
                OpExecutionFrame info = new OpExecutionFrame(this, oid, ctx, actionId, userId, aid, op, timeout, test);
                try {
                    this.opTodo.put(info);
                    return true;
                }
                catch (Exception ex4) {
                    ex4.printStackTrace();
                    throw new CartagoException("exec op exception.");
                }
            }
            try {
                ev = this.eventRegistry.makeActionFailedEvent(actionId, "Security exception", new Tuple("security_exception", userId, aid), op);
                ctx.notifyCartagoEvent(ev);
                return false;
            }
            catch (Exception ex5) {
                ex5.printStackTrace();
                throw new CartagoException("exec op exception.");
            }
        }
        OpRequestInfo request = new OpRequestInfo(actionId, userId, aid, op);
        this.wspRuleEngine.processActionRequest(request);
        if (!request.isFailed()) {
            oid = des.getAdapter().getFreshId(request.getOp().getName(), userId);
            OpExecutionFrame frame = new OpExecutionFrame(this, oid, ctx, actionId, userId, aid, request.getOp(), timeout, test);
            try {
                this.opTodo.put(frame);
                return true;
            }
            catch (Exception ex6) {
                ex6.printStackTrace();
                throw new CartagoException("exec op exception.");
            }
        }
        try {
            ev = this.eventRegistry.makeActionFailedEvent(actionId, request.getFailureMsg(), request.getFailureDesc(), op);
            ctx.notifyCartagoEvent(ev);
            return false;
        }
        catch (Exception ex7) {
            ex7.printStackTrace();
            throw new CartagoException("exec op exception.");
        }
    }

    public void setWSPRuleEngine(AbstractWSPRuleEngine man) {
        this.wspRuleEngine = man;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wspRuleManExecOp(ArtifactId aid, Op op) {
        ArtifactDescriptor des = null;
        AgentId id = this.wspManager.getAgentId();
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(aid.getName());
            if (des == null) {
                return false;
            }
        }
        OpId oid = des.getAdapter().getFreshId(op.getName(), id);
        OpExecutionFrame info = new OpExecutionFrame(this, oid, null, -2L, id, aid, op, -1L, null);
        try {
            this.opTodo.put(info);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArtifactObsProperty wspRuleManReadObsProperty(ArtifactId id, String propName) {
        try {
            HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
            synchronized (hashMap) {
                ArtifactDescriptor des = this.artifactMap.get(id.getName());
                if (des != null) {
                    AbstractArtifactAdapter ad = des.getAdapter();
                    return ad.readProperty(propName);
                }
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void logState() {
        this.log("DUMP -- WSP " + this.getId());
        for (ArtifactDescriptor des : this.artifactMap.values()) {
            this.log("Artifact: " + des.getArtifact().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArtifactObsProperty> focus(AgentId userId, IEventFilter filter, ICartagoCallback ctx, ArtifactId aid) throws CartagoException {
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(aid.getName());
            if (des == null) {
                throw new ArtifactNotAvailableException();
            }
        }
        try {
            List<ArtifactObsProperty> obs = des.getAdapter().readProperties();
            des.addObserver(userId, filter, ctx);
            HashMap<String, AgentBody> hashMap2 = this.joinedAgents;
            synchronized (hashMap2) {
                AgentBody body = this.joinedAgents.get(userId.getGlobalId());
                if (body != null) {
                    body.addFocusedArtifacts(des);
                }
            }
            if (this.logManager.isLogging()) {
                this.logManager.artifactFocussed(System.currentTimeMillis(), userId, aid, filter);
            }
            return obs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ArtifactNotAvailableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArtifactObsProperty> stopFocus(AgentId userId, ICartagoCallback ctx, ArtifactId aid) throws CartagoException {
        ArtifactDescriptor des = null;
        HashMap<String, Object> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(aid.getName());
            if (des == null) {
                throw new ArtifactNotAvailableException();
            }
        }
        des.removeObserver(userId);
        hashMap = this.joinedAgents;
        synchronized (hashMap) {
            AgentBody body = this.joinedAgents.get(userId.getGlobalId());
            if (body != null) {
                body.removeFocusedArtifacts(des);
            }
        }
        if (this.logManager.isLogging()) {
            this.logManager.artifactNoMoreFocussed(System.currentTimeMillis(), userId, aid);
        }
        List<ArtifactObsProperty> obs = des.getAdapter().readProperties();
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkArtifacts(AgentId userId, ArtifactId artifactOutId, String artifactOutPort, ArtifactId artifactInId) throws CartagoException {
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(artifactOutId.getName());
            if (des == null) {
                throw new ArtifactNotAvailableException();
            }
        }
        des.getAdapter().linkTo(artifactInId, artifactOutPort);
        if (this.logManager.isLogging()) {
            this.logManager.artifactsLinked(System.currentTimeMillis(), userId, artifactOutId, artifactInId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpId doInternalOp(ArtifactId aid, Op op) throws InterruptedException, OpRequestTimeoutException, OperationUnavailableException, ArtifactNotAvailableException, CartagoException {
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(aid.getName());
        }
        if (des != null) {
            OpId oid = des.getAdapter().getFreshId(op.getName(), this.wspManager.getAgentId());
            OpExecutionFrame info = new OpExecutionFrame(this, oid, aid, op);
            this.opTodo.put(info);
            return oid;
        }
        throw new ArtifactNotAvailableException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOperation(ArtifactId aid, Op op) throws NoArtifactException {
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(aid.getName());
            if (des == null) {
                throw new NoArtifactException(op.getName());
            }
            return des.getAdapter().hasOperation(op);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactId getArtifact(String name) {
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(name);
            if (des != null) {
                return des.getArtifact().getId();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpId execInterArtifactOp(ICartagoCallback evListener, long callbackId, AgentId userId, ArtifactId srcId, ArtifactId targetId, Op op, long timeout, IAlignmentTest test) throws CartagoException {
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(targetId.getName());
            if (des == null) {
                throw new ArtifactNotAvailableException();
            }
        }
        OpId oid = des.getAdapter().getFreshId(op.getName(), userId);
        OpExecutionFrame info = new OpExecutionFrame(this, oid, evListener, callbackId, userId, targetId, op, timeout, test);
        try {
            this.opTodo.put(info);
            return oid;
        }
        catch (Exception ex) {
            throw new CartagoException("execInterArtifactOp failed: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manual getManual(AgentId userId, String manualName) throws ManualNotAvailableException {
        HashMap<String, Manual> hashMap = this.artManuals;
        synchronized (hashMap) {
            Manual man = this.artManuals.get(manualName);
            if (man == null) {
                throw new ManualNotAvailableException(manualName);
            }
            return man;
        }
    }

    public Manual registerManual(String artifactType, String uri, String src) throws Exception {
        if (src != null) {
            HashMap<String, Manual> hashMap = this.artManuals;
            synchronized (hashMap) {
                Manual man = this.artManuals.get(artifactType);
                if (man != null) {
                    return man;
                }
                try {
                    man = new Manual(artifactType, new URI(uri));
                    man.setSource(src);
                    this.artManuals.put(artifactType, man);
                    return man;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new InvalidManualException(artifactType);
                }
            }
        }
        return Manual.EMPTY_MANUAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeManual(String name) {
        HashMap<String, Manual> hashMap = this.artManuals;
        synchronized (hashMap) {
            Manual man = this.artManuals.remove(name);
            return man != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveOperation(OpExecutionFrame info) {
        ArtifactId aid = info.getTargetArtifactId();
        AbstractArtifactAdapter adapter = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            ArtifactDescriptor des = this.artifactMap.get(aid.getName());
            adapter = des.getAdapter();
            ++this.nBusyControllers;
            if (this.nBusyControllers >= this.controllers.size()) {
                this.addControllers(10);
            }
        }
        try {
            adapter.doOperation(info);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        hashMap = this.artifactMap;
        synchronized (hashMap) {
            --this.nBusyControllers;
        }
    }

    public void addControllers(int n) {
        for (int i = 0; i < n; ++i) {
            EnvironmentController controller = new EnvironmentController(this, this.opTodo);
            this.controllers.add(controller);
            controller.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.isShutdown = true;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            final Collection<ArtifactDescriptor> list = this.artifactMap.values();
            final CountDownLatch latch = new CountDownLatch(1);
            new Thread(){

                @Override
                public void run() {
                    for (ArtifactDescriptor des : list) {
                        des.getArtifact().dispose();
                    }
                    latch.countDown();
                }
            }.start();
            try {
                latch.await(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                this.log("Disposal of artifacts not completed in 20 seconds.");
            }
        }
        for (EnvironmentController c : this.controllers) {
            c.stopActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObsEventToAgent(ArtifactId sourceId, AgentId target, Tuple signal, ArtifactObsProperty[] changed, ArtifactObsProperty[] added, ArtifactObsProperty[] removed) {
        try {
            if (this.logManager.isLogging()) {
                this.logManager.newPercept(System.currentTimeMillis(), sourceId, signal, added, removed, changed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArtifactObsEvent ev = this.eventRegistry.makeObsEvent(sourceId, signal, changed, added, removed);
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(sourceId.getName());
        }
        if (des != null) {
            des.notifyObserver(target, ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObsEvent(ArtifactId sourceId, Tuple signal, ArtifactObsProperty[] changed, ArtifactObsProperty[] added, ArtifactObsProperty[] removed) {
        try {
            if (this.logManager.isLogging()) {
                this.logManager.newPercept(System.currentTimeMillis(), sourceId, signal, added, removed, changed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArtifactObsEvent ev = this.eventRegistry.makeObsEvent(sourceId, signal, changed, added, removed);
        ArtifactDescriptor des = null;
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            des = this.artifactMap.get(sourceId.getName());
        }
        if (des != null) {
            des.notifyObservers(ev);
            if (this.wspRuleEngine != null) {
                if (changed != null) {
                    this.wspRuleEngine.processObsPropertyChanged(sourceId, changed);
                }
                if (added != null) {
                    this.wspRuleEngine.processObsPropertyAdded(sourceId, added);
                }
                if (removed != null) {
                    this.wspRuleEngine.processObsPropertyRemoved(sourceId, removed);
                }
            }
        }
        if (signal != null && this.wspRuleEngine != null) {
            this.wspRuleEngine.processSignal(signal);
        }
    }

    public void notifyActionCompleted(ICartagoCallback listener, long actionId, ArtifactId aid, Op op) {
        ActionSucceededEvent ev = this.eventRegistry.makeActionSucceededEvent(actionId, aid, op);
        listener.notifyCartagoEvent(ev);
    }

    public void notifyActionCompleted(ICartagoCallback listener, long actionId, ArtifactId aid, Op op, AgentId userId) {
        ActionSucceededEvent ev = this.eventRegistry.makeActionSucceededEvent(actionId, aid, op);
        if (this.wspRuleEngine != null) {
            this.wspRuleEngine.processActionCompleted(ev, userId);
        }
        listener.notifyCartagoEvent(ev);
    }

    public void notifyActionFailed(ICartagoCallback listener, long actionId, Op op, String failureMsg, Tuple failureReason) {
        ActionFailedEvent ev = this.eventRegistry.makeActionFailedEvent(actionId, failureMsg, failureReason, op);
        listener.notifyCartagoEvent(ev);
    }

    public void notifyFocusCompleted(ICartagoCallback listener, long actionId, ArtifactId aid, Op op, ArtifactId target, List<ArtifactObsProperty> props) {
        FocusSucceededEvent ev = this.eventRegistry.makeFocusActionSucceededEvent(actionId, aid, op, target, props);
        listener.notifyCartagoEvent(ev);
    }

    public void notifyStopFocusCompleted(ICartagoCallback listener, long actionId, ArtifactId aid, Op op, ArtifactId target, List<ArtifactObsProperty> props) {
        StopFocusSucceededEvent ev = this.eventRegistry.makeStopFocusActionSucceededEvent(actionId, aid, op, target, props);
        listener.notifyCartagoEvent(ev);
    }

    public void notifyJoinWSPCompleted(ICartagoCallback listener, long actionId, ArtifactId aid, Op op, WorkspaceId wspId, ICartagoContext ctx) {
        JoinWSPSucceededEvent ev = this.eventRegistry.makeJoinWSPSucceededEvent(actionId, aid, op, wspId, ctx);
        listener.notifyCartagoEvent(ev);
    }

    public void notifyQuitWSPCompleted(ICartagoCallback listener, long actionId, ArtifactId aid, Op op, WorkspaceId wspId) {
        QuitWSPSucceededEvent ev = this.eventRegistry.makeQuitWSPSucceededEvent(actionId, aid, op, wspId);
        listener.notifyCartagoEvent(ev);
    }

    public void notifyConsultManualCompleted(ICartagoCallback listener, long actionId, ArtifactId aid, Op op, Manual man) {
        ConsultManualSucceededEvent ev = this.eventRegistry.makeConsultManualSucceededEvent(actionId, aid, op, man);
        listener.notifyCartagoEvent(ev);
    }

    protected void log(String st) {
        System.out.println("[ENV] " + st);
    }

    HashMap<String, AgentBody> getCurrentAgentContexts() {
        return this.joinedAgents;
    }

    public void removeGarbageBody(AgentBody ctx) {
        try {
            this.quitAgent(ctx.getAgentId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log("CONTEXT TO REMOVE NOT FOUND: " + this.id);
        }
    }

    public ICartagoController getController() {
        return new CartagoController(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArtifactId[] getCurrentArtifacts() {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            Collection<ArtifactDescriptor> set = this.artifactMap.values();
            ArtifactId[] ids = new ArtifactId[set.size()];
            int index = 0;
            for (ArtifactDescriptor des : set) {
                ids[index++] = des.getArtifact().getId();
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentId[] getCurrentAgents() {
        HashMap<String, AgentBody> hashMap = this.joinedAgents;
        synchronized (hashMap) {
            Collection<AgentBody> set = this.joinedAgents.values();
            AgentId[] ids = new AgentId[set.size()];
            int index = 0;
            for (AgentBody b : set) {
                ids[index++] = b.getAgentId();
            }
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeArtifact(String artifactName) {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            ArtifactDescriptor des = this.artifactMap.remove(artifactName);
            if (des != null) {
                try {
                    Method[] ms;
                    Class<?> c = des.getArtifact().getClass();
                    for (Method m : ms = c.getDeclaredMethods()) {
                        if (!m.getName().equals("dispose")) continue;
                        m.setAccessible(true);
                        m.invoke((Object)des.getArtifact(), new Object[0]);
                        break;
                    }
                    if (this.logManager.isLogging()) {
                        this.logManager.artifactDisposed(System.currentTimeMillis(), des.getArtifact().getId(), null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAgent(String globalId) {
        HashMap<String, AgentBody> hashMap = this.joinedAgents;
        synchronized (hashMap) {
            AgentBody body = this.joinedAgents.remove(globalId);
            if (body != null) {
                if (body.getAgentBodyArtifact() != null) {
                    try {
                        this.disposeArtifact(this.wspManager.getAgentId(), body.getAgentBodyArtifact().getId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                HashMap<String, ArtifactDescriptor> hashMap2 = this.artifactMap;
                synchronized (hashMap2) {
                    for (ArtifactDescriptor des : this.artifactMap.values()) {
                        des.removeObserver(body.getAgentId());
                    }
                }
                return true;
            }
            return false;
        }
    }

    private ArtifactInfo getArtifactInfo(String artifactName) throws CartagoException {
        HashMap<String, ArtifactDescriptor> hashMap = this.artifactMap;
        synchronized (hashMap) {
            ArtifactDescriptor des = this.artifactMap.get(artifactName);
            AbstractArtifactAdapter ad = des.getAdapter();
            if (des != null) {
                ArtifactInfo info = new ArtifactInfo(des.getAgentCreator(), des.getArtifact().getId(), ad.getOperations(), ad.readProperties(), ad.getOpInExecution(), ad.getManual());
                return info;
            }
            throw new CartagoException();
        }
    }

    public String loadManualSrc(String fname) {
        try {
            InputStream is = null;
            is = this.getClass().getClassLoader().getResourceAsStream(fname);
            try {
                if (is == null) {
                    is = new FileInputStream(new File(fname));
                }
            }
            catch (Exception ex) {
                this.log("current path: " + new File(".").getAbsolutePath());
                this.log("locating the manual " + fname + " in local 'manuals' folder");
                String[] sts = fname.split("/");
                is = new FileInputStream(new File("manuals" + File.separator + sts[sts.length - 1]));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuffer src = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                src.append(line);
                line = br.readLine();
            }
            return src.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Manual source not found: " + fname);
            return null;
        }
    }

    class CartagoController
    implements ICartagoController {
        private WorkspaceKernel env;

        public CartagoController(WorkspaceKernel env) {
            this.env = env;
        }

        @Override
        public ArtifactId[] getCurrentArtifacts() throws CartagoException {
            return this.env.getCurrentArtifacts();
        }

        @Override
        public AgentId[] getCurrentAgents() throws CartagoException {
            return this.env.getCurrentAgents();
        }

        @Override
        public boolean removeArtifact(String artifactName) throws CartagoException {
            return this.env.removeArtifact(artifactName);
        }

        @Override
        public boolean removeAgent(String globalId) throws CartagoException {
            return this.env.removeAgent(globalId);
        }

        @Override
        public ArtifactInfo getArtifactInfo(String artifactName) throws CartagoException {
            return this.env.getArtifactInfo(artifactName);
        }
    }

    class EnvironmentController
    extends Thread {
        private ArrayBlockingQueue<OpExecutionFrame> opBuffer;
        private WorkspaceKernel env;
        private boolean stopped;
        private int nfailures;

        public EnvironmentController(WorkspaceKernel env, ArrayBlockingQueue<OpExecutionFrame> opBuffer) {
            this.env = env;
            this.opBuffer = opBuffer;
            this.nfailures = 0;
        }

        public synchronized void stopActivity() {
            this.stopped = true;
            this.interrupt();
        }

        public synchronized boolean isStopped() {
            return this.stopped;
        }

        @Override
        public void run() {
            OpExecutionFrame item2;
            this.stopped = false;
            while (!this.isStopped()) {
                try {
                    item2 = this.opBuffer.take();
                    item2.setServingThread(Thread.currentThread());
                    this.env.serveOperation(item2);
                }
                catch (Exception item2) {}
            }
            while (!this.opBuffer.isEmpty()) {
                try {
                    item2 = this.opBuffer.poll();
                    if (item2 == null) continue;
                    item2.setServingThread(Thread.currentThread());
                    this.env.serveOperation(item2);
                }
                catch (Exception exception) {}
            }
        }
    }
}

