/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AbstractWSPRuleEngine;
import cartago.AbstractWorkspaceTopology;
import cartago.AgentId;
import cartago.Artifact;
import cartago.ArtifactAlreadyPresentException;
import cartago.ArtifactConfig;
import cartago.ArtifactConfigurationFailedException;
import cartago.ArtifactFactory;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.GUARD;
import cartago.IEventFilter;
import cartago.LINK;
import cartago.OPERATION;
import cartago.OpExecutionFrame;
import cartago.OpFeedbackParam;
import cartago.UnknownArtifactTemplateException;
import cartago.WorkspaceId;
import cartago.WorkspaceKernel;
import cartago.security.IArtifactUsePolicy;
import cartago.security.IWorkspaceSecurityManager;
import cartago.security.SecurityException;
import java.util.List;

public class WorkspaceArtifact
extends Artifact {
    private WorkspaceKernel wspKernel;

    @OPERATION
    void init(WorkspaceKernel env) {
        this.wspKernel = env;
    }

    @OPERATION
    void focus(ArtifactId aid) {
        AgentId userId = this.getCurrentOpAgentId();
        OpExecutionFrame opFrame = this.getOpFrame();
        try {
            List<ArtifactObsProperty> props = this.wspKernel.focus(userId, null, opFrame.getAgentListener(), aid);
            this.wspKernel.notifyFocusCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), aid, props);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Artifact Not Available.");
        }
    }

    @OPERATION
    void focus(ArtifactId aid, IEventFilter filter) {
        AgentId userId = this.getCurrentOpAgentId();
        OpExecutionFrame opFrame = this.getOpFrame();
        try {
            List<ArtifactObsProperty> props = this.wspKernel.focus(userId, filter, opFrame.getAgentListener(), aid);
            this.wspKernel.notifyFocusCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), aid, props);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Artifact Not Available.");
        }
    }

    @OPERATION
    void focusWhenAvailable(String artName) {
        AgentId userId = this.getCurrentOpAgentId();
        OpExecutionFrame opFrame = this.getOpFrame();
        try {
            ArtifactId aid = null;
            while (aid == null) {
                this.await("artifactAvailable", artName);
                aid = this.wspKernel.getArtifact(artName);
            }
            List<ArtifactObsProperty> props = this.wspKernel.focus(userId, null, opFrame.getAgentListener(), aid);
            this.wspKernel.notifyFocusCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), aid, props);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Artifact Not Available.");
        }
    }

    @OPERATION
    void focusWhenAvailable(String artName, IEventFilter filter) {
        AgentId userId = this.getCurrentOpAgentId();
        OpExecutionFrame opFrame = this.getOpFrame();
        try {
            ArtifactId aid = null;
            while (aid == null) {
                this.await("artifactAvailable", artName);
                aid = this.wspKernel.getArtifact(artName);
            }
            List<ArtifactObsProperty> props = this.wspKernel.focus(userId, filter, opFrame.getAgentListener(), aid);
            this.wspKernel.notifyFocusCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), aid, props);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Artifact Not Available.");
        }
    }

    @GUARD
    boolean artifactAvailable(String artName) {
        return this.wspKernel.getArtifact(artName) != null;
    }

    @OPERATION
    void stopFocus(ArtifactId aid) {
        AgentId userId = this.getCurrentOpAgentId();
        OpExecutionFrame opFrame = this.getOpFrame();
        try {
            List<ArtifactObsProperty> props = this.wspKernel.stopFocus(userId, opFrame.getAgentListener(), aid);
            this.wspKernel.notifyStopFocusCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), aid, props);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Artifact Not Available.");
        }
    }

    @OPERATION
    void linkArtifacts(ArtifactId artifactOutId, String artifactOutPort, ArtifactId artifactInId) {
        AgentId userId = this.getCurrentOpAgentId();
        try {
            this.wspKernel.linkArtifacts(userId, artifactOutId, artifactOutPort, artifactInId);
        }
        catch (Exception ex) {
            this.failed("Artifact Not Available.");
        }
    }

    @OPERATION
    void quitWorkspace() {
        try {
            OpExecutionFrame opFrame = this.getOpFrame();
            this.wspKernel.quitAgent(opFrame.getAgentId());
            WorkspaceId wspId = this.getId().getWorkspaceId();
            this.wspKernel.notifyQuitWSPCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), wspId);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Quit Workspace failed.");
        }
    }

    @OPERATION
    @LINK
    void lookupArtifact(String artifactName, OpFeedbackParam<ArtifactId> aid) {
        try {
            ArtifactId id = this.wspKernel.lookupArtifact(this.getCurrentOpAgentId(), artifactName);
            aid.set(id);
        }
        catch (Exception ex) {
            this.failed(ex.toString());
        }
    }

    @OPERATION
    @LINK
    void lookupArtifactByType(String artifactType, OpFeedbackParam<ArtifactId> aid) {
        try {
            ArtifactId id = this.wspKernel.lookupArtifactByType(this.getCurrentOpAgentId(), artifactType);
            aid.set(id);
        }
        catch (Exception ex) {
            this.failed(ex.toString());
        }
    }

    @OPERATION
    @LINK
    void getCurrentArtifacts(OpFeedbackParam<String[]> list) {
        try {
            String[] names = this.wspKernel.getArtifactList();
            list.set(names);
        }
        catch (Exception ex) {
            this.failed(ex.toString());
        }
    }

    @OPERATION
    @LINK
    void addArtifactFactory(ArtifactFactory factory) {
        this.wspKernel.addArtifactFactory(factory);
    }

    @OPERATION
    @LINK
    void removeArtifactFactory(String name) {
        this.wspKernel.removeArtifactFactory(name);
    }

    @OPERATION
    @LINK
    void makeArtifact(String artifactName, String templateName) {
        try {
            ArtifactId id = this.wspKernel.makeArtifact(this.getCurrentOpAgentId(), artifactName, templateName, ArtifactConfig.DEFAULT_CONFIG);
            this.defineObsProperty("artifact", artifactName, templateName, id);
        }
        catch (UnknownArtifactTemplateException ex) {
            this.failed("artifact " + artifactName + " creation failed: unknown template " + templateName, "makeArtifactFailure", "unknown_artifact_template", templateName);
        }
        catch (ArtifactAlreadyPresentException ex) {
            this.failed("artifact " + artifactName + " creation failed: " + artifactName + "already present", "makeArtifactFailure", "artifact_already_present", artifactName);
        }
        catch (ArtifactConfigurationFailedException ex) {
            this.failed("artifact " + artifactName + " creation failed: an error occurred in artifact initialisation", "makeArtifactFailure", "init_failed", artifactName);
        }
    }

    @OPERATION
    @LINK
    void makeArtifact(String artifactName, String templateName, Object[] param) {
        try {
            ArtifactId id = this.wspKernel.makeArtifact(this.getCurrentOpAgentId(), artifactName, templateName, new ArtifactConfig(param));
            this.defineObsProperty("artifact", artifactName, templateName, id);
        }
        catch (UnknownArtifactTemplateException ex) {
            this.failed("artifact " + artifactName + " creation failed: unknown template " + templateName, "makeArtifactFailure", "unknown_artifact_template", templateName);
        }
        catch (ArtifactAlreadyPresentException ex) {
            this.failed("artifact " + artifactName + " creation failed: " + artifactName + "already present", "makeArtifactFailure", "artifact_already_present", artifactName);
        }
        catch (ArtifactConfigurationFailedException ex) {
            this.failed("artifact " + artifactName + " creation failed: an error occurred in artifact initialisation", "makeArtifactFailure", "init_failed", artifactName);
        }
    }

    @OPERATION
    @LINK
    void makeArtifact(String artifactName, String templateName, Object[] params, OpFeedbackParam<ArtifactId> aid) {
        try {
            ArtifactId id = this.wspKernel.makeArtifact(this.getCurrentOpAgentId(), artifactName, templateName, new ArtifactConfig(params));
            aid.set(id);
            this.defineObsProperty("artifact", artifactName, templateName, id);
        }
        catch (UnknownArtifactTemplateException ex) {
            this.failed("artifact " + artifactName + " creation failed: unknown template " + templateName, "makeArtifactFailure", "unknown_artifact_template", templateName);
        }
        catch (ArtifactAlreadyPresentException ex) {
            this.failed("artifact " + artifactName + " creation failed: " + artifactName + "already present", "makeArtifactFailure", "artifact_already_present", artifactName);
        }
        catch (ArtifactConfigurationFailedException ex) {
            this.failed("artifact " + artifactName + " creation failed: an error occurred in artifact initialisation", "makeArtifactFailure", "init_failed", artifactName);
        }
    }

    @OPERATION
    @LINK
    void disposeArtifact(ArtifactId id) {
        try {
            this.wspKernel.disposeArtifact(this.getCurrentOpAgentId(), id);
            this.removeObsPropertyByTemplate("artifact", id.getName(), null, id);
        }
        catch (Exception ex) {
            this.failed(ex.toString());
        }
    }

    @OPERATION
    void setWSPRuleEngine(AbstractWSPRuleEngine man) {
        try {
            man.setKernel(this.wspKernel);
            this.wspKernel.setWSPRuleEngine(man);
        }
        catch (Exception ex) {
            this.failed(ex.getMessage());
        }
    }

    @OPERATION
    void setWorkspaceTopology(AbstractWorkspaceTopology topology) {
        try {
            this.wspKernel.setWSPTopology(topology);
        }
        catch (Exception ex) {
            this.failed(ex.getMessage());
        }
    }

    @OPERATION
    void setSecurityManager(IWorkspaceSecurityManager man) {
        this.wspKernel.setSecurityManager(man);
    }

    @OPERATION
    void addRole(String roleName) {
        try {
            this.wspKernel.getSecurityManager().addRole(roleName);
        }
        catch (SecurityException ex) {
            this.failed("security_exception");
        }
    }

    @OPERATION
    void removeRole(String roleName) {
        this.wspKernel.getSecurityManager().removeRole(roleName);
    }

    @OPERATION
    void getRoleList(OpFeedbackParam<String[]> list) {
        list.set(this.wspKernel.getSecurityManager().getRoleList());
    }

    @OPERATION
    void addRolePolicy(String roleName, String artifactName, IArtifactUsePolicy policy) {
        try {
            this.wspKernel.getSecurityManager().addRolePolicy(roleName, artifactName, policy);
        }
        catch (SecurityException ex) {
            this.failed("security_exception");
        }
    }

    @OPERATION
    void removeRolePolicy(String roleName, String artifactName) {
        try {
            this.wspKernel.getSecurityManager().removeRolePolicy(roleName, artifactName);
        }
        catch (SecurityException ex) {
            this.failed("security_exception");
        }
    }

    @OPERATION
    void setDefaultRolePolicy(String roleName, String artName, IArtifactUsePolicy policy) {
        try {
            this.wspKernel.getSecurityManager().setDefaultRolePolicy(roleName, policy);
        }
        catch (SecurityException ex) {
            this.failed("security_exception");
        }
    }

    @LINK
    void getArtifactList(OpFeedbackParam<ArtifactId[]> artifacts) {
        artifacts.set(this.wspKernel.getArtifactIdList());
    }
}

