/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.Artifact;
import cartago.ArtifactFactory;
import cartago.CartagoException;
import java.net.URL;
import java.net.URLClassLoader;

public class URLArtifactFactory
extends ArtifactFactory {
    public String address;
    public URLClassLoader cloader;

    public URLArtifactFactory(String name, URL address) {
        super(name);
        this.cloader = new URLClassLoader(new URL[]{address}, this.getClass().getClassLoader());
    }

    @Override
    public Artifact createArtifact(String templateName) throws CartagoException {
        try {
            Class<?> cl = this.cloader.loadClass(templateName);
            return (Artifact)cl.newInstance();
        }
        catch (Exception ex) {
            throw new CartagoException("Template not found: " + templateName + " at " + this.address);
        }
    }
}

