/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.Tuple;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class PendingOp {
    private boolean hasSucceeded;
    private boolean hasCompleted;
    private ReentrantLock lock = new ReentrantLock();
    private Condition completed = this.lock.newCondition();
    private String failure;
    private Tuple failureDesc;
    private long actionId;

    public PendingOp(long actionId) {
        this.actionId = actionId;
        this.hasSucceeded = false;
        this.hasCompleted = false;
    }

    public long getActionId() {
        return this.actionId;
    }

    public boolean hasCompleted() {
        try {
            this.lock.lock();
            boolean bl = this.hasCompleted;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasSucceeded() {
        try {
            this.lock.lock();
            boolean bl = this.hasSucceeded;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getFailure() {
        return this.failure;
    }

    public Tuple getFailureDesc() {
        return this.failureDesc;
    }

    public void waitForCompletion() {
        try {
            this.lock.lock();
            while (!this.hasCompleted) {
                this.completed.await();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyOpFailure(String reason, Tuple desc) {
        try {
            this.lock.lock();
            this.hasSucceeded = false;
            this.hasCompleted = true;
            this.failure = reason;
            this.failureDesc = desc;
            this.completed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void notifyOpSuccess() {
        try {
            this.lock.lock();
            this.hasSucceeded = true;
            this.hasCompleted = true;
            this.completed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

