/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.Op;
import cartago.OpId;
import cartago.Tuple;
import cartago.WorkspaceKernel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class OpExecutionFrame {
    private OpExecState state;
    private ICartagoCallback eventListener;
    private long actionId;
    private AgentId userId;
    private OpId oid;
    private Op op;
    private int ncount;
    private long timeout;
    private ArtifactId aid;
    private Thread servingThread;
    private WorkspaceKernel kernel;
    private ArtifactId sourceId;
    private IAlignmentTest alignmentTest;
    private ReentrantLock lock;
    private Condition opSignaled;
    private String failureMsg;
    private Tuple failureReason;
    boolean alreadyNotified;

    public OpExecutionFrame(WorkspaceKernel kernel, OpId oid, ICartagoCallback ctx, long actionId, AgentId id, ArtifactId aid, Op op, long timeout, IAlignmentTest test) {
        this.oid = oid;
        this.op = op;
        this.aid = aid;
        this.userId = id;
        this.alignmentTest = test;
        this.ncount = 0;
        this.timeout = timeout;
        this.sourceId = null;
        this.actionId = actionId;
        this.eventListener = ctx;
        this.lock = new ReentrantLock();
        this.opSignaled = this.lock.newCondition();
        this.state = OpExecState.EXECUTING;
        this.kernel = kernel;
        this.alreadyNotified = false;
    }

    public OpExecutionFrame(WorkspaceKernel kernel, OpId oid, ArtifactId source, ICartagoCallback ctx, long actionId, AgentId id, ArtifactId aid, Op op, long timeout) {
        this.oid = oid;
        this.eventListener = ctx;
        this.op = op;
        this.aid = aid;
        this.userId = id;
        this.ncount = 0;
        this.timeout = timeout;
        this.sourceId = source;
        this.actionId = actionId;
        this.lock = new ReentrantLock();
        this.opSignaled = this.lock.newCondition();
        this.state = OpExecState.EXECUTING;
        this.kernel = kernel;
        this.alreadyNotified = false;
    }

    public OpExecutionFrame(WorkspaceKernel kernel, OpId oid, ArtifactId aid, Op op) {
        this.oid = oid;
        this.op = op;
        this.aid = aid;
        this.ncount = 0;
        this.sourceId = null;
        this.lock = new ReentrantLock();
        this.opSignaled = this.lock.newCondition();
        this.state = OpExecState.EXECUTING;
        this.kernel = kernel;
        this.alreadyNotified = false;
    }

    public OpId getOpId() {
        return this.oid;
    }

    public AgentId getAgentId() {
        return this.userId;
    }

    ICartagoCallback getAgentListener() {
        return this.eventListener;
    }

    public ArtifactId getSourceArtifactId() {
        return this.sourceId;
    }

    public long getActionId() {
        return this.actionId;
    }

    public Op getOperation() {
        return this.op;
    }

    public void setCompletionNotified() {
        this.alreadyNotified = true;
    }

    public boolean completionNotified() {
        return this.alreadyNotified;
    }

    public boolean isInternalOp() {
        return this.eventListener == null;
    }

    public boolean isLinkedOp() {
        return this.sourceId != null;
    }

    public ArtifactId getTargetArtifactId() {
        return this.aid;
    }

    public IAlignmentTest getAlignmentTest() {
        return this.alignmentTest;
    }

    public void setFailed(String reason, Tuple descr) {
        this.state = OpExecState.FAILED;
        this.failureMsg = reason;
        this.failureReason = descr;
    }

    public boolean isFailed() {
        return this.state == OpExecState.FAILED;
    }

    public boolean isSucceeded() {
        return this.state == OpExecState.SUCCEEDED;
    }

    public String getFailureMsg() {
        return this.failureMsg;
    }

    public Tuple getFailureReason() {
        return this.failureReason;
    }

    public void setServingThread(Thread t) {
        this.servingThread = t;
    }

    public Thread getServingThread() {
        return this.servingThread;
    }

    public void notifyOpCompletion() {
        if (this.actionId != -1L) {
            this.kernel.notifyActionCompleted(this.eventListener, this.actionId, this.aid, this.op, this.userId);
        }
    }

    public void notifyOpFailed() {
        if (this.actionId != -1L) {
            this.kernel.notifyActionFailed(this.eventListener, this.actionId, this.op, this.failureMsg, this.failureReason);
        }
    }

    public void notifyOpFailed(String failureMsg, Tuple failureReason) {
        if (this.actionId != -1L) {
            this.kernel.notifyActionFailed(this.eventListener, this.actionId, this.op, failureMsg, failureReason);
        }
    }

    public int synchLinkingArtifactOk() {
        this.lock.lock();
        try {
            if (this.ncount < 0) {
                int n = this.ncount;
                return n;
            }
            ++this.ncount;
            if (this.ncount < 2) {
                block12: {
                    this.opSignaled.await(this.timeout, TimeUnit.MILLISECONDS);
                    if (this.ncount >= 0) break block12;
                    int n = this.ncount;
                    return n;
                }
                try {
                    if (this.ncount < 2) {
                        this.ncount = -1;
                    }
                }
                catch (Exception ex) {
                    this.ncount = -3;
                }
                int n = this.ncount;
                return n;
            }
            this.opSignaled.signalAll();
            int n = 2;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static enum OpExecState {
        EXECUTING,
        SUCCEEDED,
        NOT_ALIGNED,
        TIME_OUT,
        INTERRUPTED,
        OP_NOT_EXIST,
        FAILED;

    }
}

