/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.IArtifactGuard;
import cartago.IArtifactOp;

public class OpDescriptor {
    private IArtifactOp op;
    private IArtifactGuard guard;
    private String id;
    private OpType type;

    public OpDescriptor(String id, IArtifactOp op, IArtifactGuard guard, OpType t) {
        this.op = op;
        this.guard = guard;
        this.type = t;
        this.id = id;
    }

    public OpDescriptor(String id, IArtifactOp op, OpType t) {
        this.op = op;
        this.guard = null;
        this.type = t;
        this.id = id;
    }

    public IArtifactOp getOp() {
        return this.op;
    }

    public IArtifactGuard getGuard() {
        return this.guard;
    }

    public String getKeyId() {
        return this.id;
    }

    public boolean isLinkOperation() {
        return this.type == OpType.LINK;
    }

    public boolean isUI() {
        return this.type == OpType.UI;
    }

    public boolean isInternalOp() {
        return this.type == OpType.INTERNAL;
    }

    public static enum OpType {
        LINK,
        UI,
        INTERNAL;

    }
}

