/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.ArtifactObsProperty;
import cartago.ObsPropMap;
import java.io.Serializable;

public class ObsProperty
implements Serializable {
    private String name;
    private Object[] values;
    private Object[] backup;
    private boolean modified;
    private ObsPropMap container;
    private long id;
    private String fullId;

    ObsProperty(ObsPropMap container, long id, String fullId, String name, Object ... values) {
        this.name = name;
        this.values = values;
        this.backup = new Object[values.length];
        this.modified = false;
        this.container = container;
        this.id = id;
        this.fullId = fullId;
    }

    public long getId() {
        return this.id;
    }

    public String getFullId() {
        return this.fullId;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(int index) {
        return this.values[index];
    }

    public Object[] getValues() {
        return this.values;
    }

    public int intValue(int index) {
        return ((Number)this.values[index]).intValue();
    }

    public double doubleValue(int index) {
        return ((Number)this.values[index]).doubleValue();
    }

    public String stringValue(int index) {
        return this.values[index].toString();
    }

    public boolean booleanValue(int index) {
        return (Boolean)this.values[index];
    }

    public float floatValue(int index) {
        return ((Number)this.values[index]).floatValue();
    }

    public long longValue(int index) {
        return ((Number)this.values[index]).longValue();
    }

    public char charValue(int index) {
        return ((Character)this.values[index]).charValue();
    }

    public int intValue() {
        return ((Number)this.values[0]).intValue();
    }

    public double doubleValue() {
        return ((Number)this.values[0]).doubleValue();
    }

    public String stringValue() {
        return this.values[0].toString();
    }

    public boolean booleanValue() {
        return (Boolean)this.values[0];
    }

    public float floatValue() {
        return ((Number)this.values[0]).floatValue();
    }

    public long longValue() {
        return ((Number)this.values[0]).longValue();
    }

    public char charValue() {
        return ((Character)this.values[0]).charValue();
    }

    public Object getValue() {
        return this.values[0];
    }

    public void updateValue(Object value) {
        if (!this.modified) {
            this.modified = true;
            for (int i = 0; i < this.values.length; ++i) {
                this.backup[i] = this.values[i];
            }
            this.container.addPropChanged(this);
        }
        this.values[0] = value;
    }

    public void commitChanges() {
        this.modified = false;
    }

    public void rollbackChanges() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.backup[i];
        }
        this.modified = false;
    }

    public void updateValue(int index, Object value) {
        if (!this.modified) {
            this.modified = true;
            for (int i = 0; i < this.values.length; ++i) {
                this.backup[i] = this.values[i];
            }
            this.container.addPropChanged(this);
        }
        this.values[index] = value;
    }

    public void updateValues(Object ... values) {
        if (!this.modified) {
            this.modified = true;
            for (int i = 0; i < values.length; ++i) {
                this.backup[i] = this.values[i];
            }
            this.container.addPropChanged(this);
        }
        this.values = values;
    }

    public boolean match(String nam, Object ... v) {
        if (!this.name.equals(nam) || this.values.length != v.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null || v[i] == null || this.values[i].equals(v[i])) continue;
            return false;
        }
        return true;
    }

    ArtifactObsProperty getUserCopy() {
        return new ArtifactObsProperty(this.fullId, this.id, this.name, (Object[])this.values.clone());
    }

    public String toString() {
        StringBuffer st = new StringBuffer(this.name);
        if (this.values.length > 0) {
            st.append("(" + this.values[0]);
            for (int i = 1; i < this.values.length; ++i) {
                st.append(",");
                String s = this.values[i].toString();
                if (s.equals("")) {
                    s = "\"\"";
                }
                st.append(s);
            }
            st.append(")");
        }
        return st.toString();
    }
}

