/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.ArtifactObsProperty;
import cartago.IObsPropMap;
import cartago.ObsProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ObsPropMap
implements IObsPropMap {
    private HashMap<String, ArrayList<ObsProperty>> props = new HashMap();
    private ArrayList<ObsProperty> propsChanged = new ArrayList();
    private ArrayList<ObsProperty> propsAdded = new ArrayList();
    private ArrayList<ObsProperty> propsRemoved = new ArrayList();

    public void add(ObsProperty prop) {
        ArrayList<ObsProperty> list = this.props.get(prop.getName());
        if (list == null) {
            list = new ArrayList();
            this.props.put(prop.getName(), list);
        }
        list.add(prop);
        this.propsAdded.add(prop);
    }

    private void addProp(ObsProperty prop) {
        ArrayList<ObsProperty> list = this.props.get(prop.getName());
        if (list == null) {
            list = new ArrayList();
            this.props.put(prop.getName(), list);
        }
        list.add(prop);
    }

    public ObsProperty getByName(String name) {
        ArrayList<ObsProperty> list = this.props.get(name);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    public ObsProperty removeByName(String name) {
        ArrayList<ObsProperty> list = this.props.get(name);
        if (list != null) {
            ObsProperty p = list.remove(0);
            this.propsRemoved.add(p);
            if (list.size() == 0) {
                this.props.remove(name);
            }
            return p;
        }
        return null;
    }

    public ObsProperty get(String name, Object ... values) {
        ArrayList<ObsProperty> list = this.props.get(name);
        if (list != null) {
            if (values.length == 0) {
                return list.get(0);
            }
            for (ObsProperty prop : list) {
                if (!prop.match(name, values)) continue;
                return prop;
            }
            return null;
        }
        return null;
    }

    public ObsProperty remove(String name, Object ... values) {
        ArrayList<ObsProperty> list = this.props.get(name);
        if (list != null) {
            if (values.length == 0) {
                this.props.remove(name);
                ObsProperty p = list.get(0);
                this.propsRemoved.add(p);
                return p;
            }
            Iterator<ObsProperty> it = list.iterator();
            while (it.hasNext()) {
                ObsProperty prop = it.next();
                if (!prop.match(name, values)) continue;
                try {
                    it.remove();
                    this.propsRemoved.add(prop);
                    return prop;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }
        return null;
    }

    private void remove(String name, long id) {
        ArrayList<ObsProperty> list = this.props.get(name);
        if (list != null) {
            Iterator<ObsProperty> it = list.iterator();
            while (it.hasNext()) {
                ObsProperty prop = it.next();
                if (prop.getId() != id) continue;
                try {
                    it.remove();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            throw new IllegalArgumentException("Internal error: removing a not existing prop " + name + " " + id);
        }
    }

    public void addPropChanged(ObsProperty prop) {
        this.propsChanged.add(prop);
    }

    public void addPropAdded(ObsProperty prop) {
        this.propsAdded.add(prop);
    }

    public void addPropRemoved(ObsProperty prop) {
        this.propsRemoved.add(prop);
    }

    public ArtifactObsProperty[] getPropsChanged() {
        if (this.propsChanged.size() > 0) {
            ArtifactObsProperty[] v = new ArtifactObsProperty[this.propsChanged.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.propsChanged.get(i).getUserCopy();
            }
            return v;
        }
        return null;
    }

    public ArtifactObsProperty[] getPropsAdded() {
        if (this.propsAdded.size() > 0) {
            ArtifactObsProperty[] v = new ArtifactObsProperty[this.propsAdded.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.propsAdded.get(i).getUserCopy();
            }
            return v;
        }
        return null;
    }

    public ArtifactObsProperty[] getPropsRemoved() {
        if (this.propsRemoved.size() > 0) {
            ArtifactObsProperty[] v = new ArtifactObsProperty[this.propsRemoved.size()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = this.propsRemoved.get(i).getUserCopy();
            }
            return v;
        }
        return null;
    }

    public void commitChanges() {
        for (ObsProperty p : this.propsChanged) {
            p.commitChanges();
        }
        this.propsChanged.clear();
        this.propsRemoved.clear();
        this.propsAdded.clear();
    }

    public void rollbackChanges() {
        for (ObsProperty p : this.propsChanged) {
            p.rollbackChanges();
        }
        this.propsChanged.clear();
        for (ObsProperty p : this.propsAdded) {
            this.remove(p.getName(), p.getId());
        }
        this.propsRemoved.clear();
        for (ObsProperty p : this.propsRemoved) {
            this.addProp(p);
        }
        this.propsAdded.clear();
    }

    @Override
    public ArtifactObsProperty getPropValue(String name, Object ... values) {
        ObsProperty prop = this.get(name, values);
        if (prop != null) {
            return new ArtifactObsProperty(prop.getFullId(), prop.getId(), prop.getName(), prop.getValues());
        }
        return null;
    }

    public ArrayList<ArtifactObsProperty> readAll() {
        ArrayList<ArtifactObsProperty> list = new ArrayList<ArtifactObsProperty>();
        for (ArrayList<ObsProperty> l : this.props.values()) {
            for (ObsProperty p : l) {
                list.add(p.getUserCopy());
            }
        }
        return list;
    }

    @Override
    public ArtifactObsProperty getPropValueByName(String name) {
        ObsProperty prop = this.getByName(name);
        if (prop != null) {
            return new ArtifactObsProperty(prop.getFullId(), prop.getId(), prop.getName(), prop.getValues());
        }
        return null;
    }
}

