/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AbstractWorkspaceTopology;
import cartago.Artifact;
import cartago.ArtifactId;
import cartago.CartagoNode;
import cartago.CartagoService;
import cartago.CartagoWorkspace;
import cartago.ICartagoContext;
import cartago.ICartagoLogger;
import cartago.LINK;
import cartago.NodeId;
import cartago.OPERATION;
import cartago.OpExecutionFrame;
import cartago.OpFeedbackParam;
import cartago.WorkspaceId;
import cartago.WorkspaceKernel;
import cartago.security.AgentCredential;
import cartago.security.AgentIdCredential;

public class NodeArtifact
extends Artifact {
    private WorkspaceKernel thisWsp;

    void init(WorkspaceKernel env) {
        this.thisWsp = env;
    }

    @OPERATION
    void joinWorkspace(String wspName, OpFeedbackParam<WorkspaceId> res) {
        try {
            OpExecutionFrame opFrame = this.getOpFrame();
            CartagoWorkspace wsp = CartagoNode.getInstance().getWorkspace(wspName);
            if (wsp != null) {
                WorkspaceKernel wspKernel = wsp.getKernel();
                ICartagoContext ctx = wspKernel.joinWorkspace(new AgentIdCredential(this.getCurrentOpAgentId().getGlobalId()), opFrame.getAgentListener());
                WorkspaceId wspId = ctx.getWorkspaceId();
                res.set(wspId);
                this.thisWsp.notifyJoinWSPCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), wspId, ctx);
                opFrame.setCompletionNotified();
            } else {
                this.failed("Workspace not available.");
            }
        }
        catch (Exception ex) {
            this.failed("Join Workspace error: " + ex.getMessage());
        }
    }

    @OPERATION
    void joinWorkspace(String wspName, AgentCredential cred, OpFeedbackParam<WorkspaceId> res) {
        try {
            OpExecutionFrame opFrame = this.getOpFrame();
            CartagoWorkspace wsp = CartagoNode.getInstance().getWorkspace(wspName);
            if (wsp != null) {
                WorkspaceKernel wspKernel = wsp.getKernel();
                ICartagoContext ctx = wspKernel.joinWorkspace(cred, opFrame.getAgentListener());
                WorkspaceId wspId = ctx.getWorkspaceId();
                res.set(wspId);
                this.thisWsp.notifyJoinWSPCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), wspId, ctx);
                opFrame.setCompletionNotified();
            } else {
                this.failed("Workspace not available.");
            }
        }
        catch (Exception ex) {
            this.failed("Join Workspace error");
        }
    }

    @OPERATION
    void joinRemoteWorkspace(String wspName, String address, OpFeedbackParam<WorkspaceId> res) {
        try {
            OpExecutionFrame opFrame = this.getOpFrame();
            ICartagoContext ctx = CartagoService.joinRemoteWorkspace(wspName, address, "default", new AgentIdCredential(this.getCurrentOpAgentId().getGlobalId()), opFrame.getAgentListener());
            WorkspaceId wspId = ctx.getWorkspaceId();
            res.set(wspId);
            this.thisWsp.notifyJoinWSPCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), wspId, ctx);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Join Workspace error");
        }
    }

    @OPERATION
    void joinRemoteWorkspace(String wspName, String address, String infraServiceType, OpFeedbackParam<WorkspaceId> res) {
        try {
            OpExecutionFrame opFrame = this.getOpFrame();
            ICartagoContext ctx = CartagoService.joinRemoteWorkspace(wspName, address, infraServiceType, new AgentIdCredential(this.getCurrentOpAgentId().getGlobalId()), opFrame.getAgentListener());
            WorkspaceId wspId = ctx.getWorkspaceId();
            res.set(wspId);
            this.thisWsp.notifyJoinWSPCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), wspId, ctx);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Join Workspace error");
        }
    }

    @OPERATION
    void joinRemoteWorkspace(String wspName, String address, String infraServiceType, String roleName, AgentCredential cred, OpFeedbackParam<WorkspaceId> res) {
        try {
            OpExecutionFrame opFrame = this.getOpFrame();
            ICartagoContext ctx = CartagoService.joinRemoteWorkspace(wspName, address, infraServiceType, cred, opFrame.getAgentListener());
            WorkspaceId wspId = ctx.getWorkspaceId();
            res.set(wspId);
            this.thisWsp.notifyJoinWSPCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), wspId, ctx);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Join Workspace error");
        }
    }

    @OPERATION
    void createWorkspace(String name) {
        try {
            CartagoWorkspace wsp = CartagoNode.getInstance().createWorkspace(name);
            this.defineObsProperty("workspace", name, wsp.getId());
        }
        catch (Exception ex) {
            this.failed("Workspace creation error");
        }
    }

    @OPERATION
    void createWorkspaceWithTopology(String name, String topologyClassName) {
        try {
            CartagoWorkspace wsp = CartagoNode.getInstance().createWorkspace(name);
            AbstractWorkspaceTopology topology = (AbstractWorkspaceTopology)Class.forName(topologyClassName).newInstance();
            wsp.setTopology(topology);
            this.defineObsProperty("workspace", name, wsp.getId());
        }
        catch (Exception ex) {
            this.failed("Workspace creation error");
        }
    }

    @OPERATION
    void getNodeId(OpFeedbackParam<NodeId> param) {
        try {
            param.set(CartagoNode.getInstance().getId());
        }
        catch (Exception ex) {
            this.failed("no_node_id");
        }
    }

    @OPERATION
    void enableLinkingWithNode(NodeId id, String support, String address) {
        CartagoService.enableLinkingWithNode(id, support, address);
    }

    @OPERATION
    void createWorkspace(String name, ICartagoLogger logger) {
        try {
            CartagoWorkspace wsp = CartagoNode.getInstance().createWorkspace(name, logger);
            this.defineObsProperty("workspace", name, wsp.getId());
        }
        catch (Exception ex) {
            this.failed("Workspace creation error");
        }
    }

    @OPERATION
    void shutdownNode() {
        try {
            CartagoService.shutdownNode();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.failed("Shutdown failed.");
        }
    }

    @OPERATION
    void crash() {
        try {
            CartagoService.shutdownNode();
            Thread.sleep(1000L);
            System.exit(0);
        }
        catch (Exception ex) {
            this.failed("Shutdown failed.");
        }
    }

    @LINK
    void lookupWorkspace(String wspName, OpFeedbackParam<ArtifactId> aid) {
        try {
            CartagoWorkspace wsp = CartagoNode.getInstance().getWorkspace(wspName);
            if (wsp != null) {
                WorkspaceKernel wspKernel = wsp.getKernel();
                aid.set(wspKernel.getArtifact("workspace"));
            } else {
                this.failed("Lookup workspace failed.");
            }
        }
        catch (Exception ex) {
            this.failed(ex.toString());
        }
    }
}

