/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.UsageProtocol;
import cartago.manual.parser.ArtifactManualParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class Manual
implements Serializable {
    private URI uri;
    private String artClass;
    private String name;
    private List<UsageProtocol> protocols;
    private String source;
    public static final Manual EMPTY_MANUAL = new Manual("", null);

    public Manual(String manualName, URI uri) {
        this.name = manualName;
        this.uri = uri;
        this.protocols = new ArrayList<UsageProtocol>();
    }

    public void setSource(String src) {
        this.source = src;
    }

    public void addUsageProtocol(UsageProtocol p) {
        this.protocols.add(p);
    }

    public List<UsageProtocol> getUsageProtocols() {
        return this.protocols;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public URI getURI() {
        return this.uri;
    }

    public static Manual parse(File file) throws Exception {
        ArtifactManualParser parser = new ArtifactManualParser(new FileInputStream(file));
        Manual man = parser.parse();
        return man;
    }

    public static Manual parse(String text) throws Exception {
        ArtifactManualParser parser = new ArtifactManualParser(new StringReader(text));
        Manual man = parser.parse();
        man.setSource(text);
        return man;
    }
}

