/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AgentId;
import cartago.Artifact;
import cartago.Manual;
import cartago.OPERATION;
import cartago.OpExecutionFrame;
import cartago.OpFeedbackParam;
import cartago.WorkspaceKernel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class ManRepoArtifact
extends Artifact {
    private WorkspaceKernel wspKernel;

    @OPERATION
    void init(WorkspaceKernel env) {
        this.wspKernel = env;
    }

    @OPERATION
    void storeManual(String artifactModelName, String uri) {
        URI id = URI.create(uri);
        if (id != null) {
            StringBuffer src = new StringBuffer("");
            if (id.getScheme() != null) {
                if (id.getScheme().equals("http")) {
                    try {
                        String inputLine;
                        URL source = new URL(uri);
                        URLConnection conn = source.openConnection();
                        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        while ((inputLine = in.readLine()) != null) {
                            src.append(inputLine);
                        }
                        in.close();
                    }
                    catch (Exception source) {}
                } else if (id.getScheme().equals("file")) {
                    try {
                        String inputLine;
                        BufferedReader in = new BufferedReader(new FileReader(id.getPath()));
                        while ((inputLine = in.readLine()) != null) {
                            src.append(inputLine);
                        }
                        in.close();
                    }
                    catch (Exception in) {
                        // empty catch block
                    }
                }
            }
            try {
                this.wspKernel.registerManual(artifactModelName, uri, src.toString());
            }
            catch (Exception ex) {
                this.failed("Invalid artifact manual.");
            }
        } else {
            this.failed("URI syntax exception");
        }
    }

    @OPERATION
    void getManualContent(String artifactModelName, OpFeedbackParam<String> content) {
        AgentId userId = this.getCurrentOpAgentId();
        try {
            Manual man = this.wspKernel.getManual(userId, artifactModelName);
            content.set(man.getSource());
        }
        catch (Exception ex) {
            this.failed("Artifact manual not available.");
        }
    }

    @OPERATION
    void consultManual(String artifactModelName) {
        AgentId userId = this.getCurrentOpAgentId();
        OpExecutionFrame opFrame = this.getOpFrame();
        try {
            Manual man = this.wspKernel.getManual(userId, artifactModelName);
            this.wspKernel.notifyConsultManualCompleted(opFrame.getAgentListener(), opFrame.getActionId(), opFrame.getSourceArtifactId(), opFrame.getOperation(), man);
            opFrame.setCompletionNotified();
        }
        catch (Exception ex) {
            this.failed("Artifact manual not available.");
        }
    }
}

