/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.CartagoEvent;
import cartago.ICartagoCallback;
import cartago.PendingOp;
import cartago.events.ActionFailedEvent;
import cartago.events.ActionSucceededEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class InterArtifactCallback
implements ICartagoCallback {
    private ConcurrentHashMap<Long, PendingOp> pendingOps;
    private AtomicLong opId = new AtomicLong(1L);

    public InterArtifactCallback(ReentrantLock lock) {
        this.pendingOps = new ConcurrentHashMap();
    }

    public PendingOp createPendingOp() {
        long id = this.opId.getAndIncrement();
        PendingOp pa = new PendingOp(id);
        this.pendingOps.put(id, pa);
        return pa;
    }

    @Override
    public void notifyCartagoEvent(CartagoEvent ev) {
        ActionFailedEvent evt;
        PendingOp o;
        if (ev instanceof ActionSucceededEvent) {
            ActionSucceededEvent evt2 = (ActionSucceededEvent)ev;
            PendingOp o2 = this.pendingOps.get(evt2.getActionId());
            if (o2 != null) {
                o2.notifyOpSuccess();
            }
        } else if (ev instanceof ActionFailedEvent && (o = this.pendingOps.get((evt = (ActionFailedEvent)ev).getActionId())) != null) {
            o.notifyOpFailure(evt.getFailureMsg(), evt.getFailureDescr());
        }
    }
}

