/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.ICartagoContext;
import cartago.Manual;
import cartago.ObservableArtifactInfo;
import cartago.Op;
import cartago.Tuple;
import cartago.WorkspaceId;
import cartago.events.ActionFailedEvent;
import cartago.events.ActionSucceededEvent;
import cartago.events.ArtifactObsEvent;
import cartago.events.ConsultManualSucceededEvent;
import cartago.events.FocusSucceededEvent;
import cartago.events.FocussedArtifactDisposedEvent;
import cartago.events.JoinWSPSucceededEvent;
import cartago.events.ObsArtListChangedEvent;
import cartago.events.QuitWSPSucceededEvent;
import cartago.events.StopFocusSucceededEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class EventRegistry {
    private AtomicLong nextTimestamp = new AtomicLong(0L);

    public long getNextTimestamp() {
        return this.nextTimestamp.longValue();
    }

    public ArtifactObsEvent makeObsEvent(ArtifactId src, Tuple signal, ArtifactObsProperty[] changed, ArtifactObsProperty[] added, ArtifactObsProperty[] removed) {
        long id = this.nextTimestamp.incrementAndGet();
        ArtifactObsEvent ev = new ArtifactObsEvent(id, src, signal, changed, added, removed);
        return ev;
    }

    public FocussedArtifactDisposedEvent makeFocussedArtifactDisposedEvent(ArtifactId target, List<ArtifactObsProperty> props) {
        long id = this.nextTimestamp.incrementAndGet();
        FocussedArtifactDisposedEvent ev = new FocussedArtifactDisposedEvent(id, target, props);
        return ev;
    }

    public ActionSucceededEvent makeActionSucceededEvent(long actionId, ArtifactId aid, Op op) {
        long id = this.nextTimestamp.incrementAndGet();
        ActionSucceededEvent ev = new ActionSucceededEvent(id, actionId, op, aid);
        return ev;
    }

    public ActionFailedEvent makeActionFailedEvent(long actionId, String failureMsg, Tuple failureReason, Op op) {
        long id = this.nextTimestamp.incrementAndGet();
        ActionFailedEvent ev = new ActionFailedEvent(id, actionId, op, failureMsg, failureReason);
        return ev;
    }

    public FocusSucceededEvent makeFocusActionSucceededEvent(long actionId, ArtifactId aid, Op op, ArtifactId target, List<ArtifactObsProperty> props) {
        long id = this.nextTimestamp.incrementAndGet();
        FocusSucceededEvent ev = new FocusSucceededEvent(id, actionId, op, aid, target, props);
        return ev;
    }

    public StopFocusSucceededEvent makeStopFocusActionSucceededEvent(long actionId, ArtifactId aid, Op op, ArtifactId target, List<ArtifactObsProperty> props) {
        long id = this.nextTimestamp.incrementAndGet();
        StopFocusSucceededEvent ev = new StopFocusSucceededEvent(id, actionId, op, aid, target, props);
        return ev;
    }

    public JoinWSPSucceededEvent makeJoinWSPSucceededEvent(long actionId, ArtifactId aid, Op op, WorkspaceId wspId, ICartagoContext ctx) {
        long id = this.nextTimestamp.incrementAndGet();
        JoinWSPSucceededEvent ev = new JoinWSPSucceededEvent(id, actionId, op, aid, wspId, ctx);
        return ev;
    }

    public QuitWSPSucceededEvent makeQuitWSPSucceededEvent(long actionId, ArtifactId aid, Op op, WorkspaceId wspId) {
        long id = this.nextTimestamp.incrementAndGet();
        QuitWSPSucceededEvent ev = new QuitWSPSucceededEvent(id, actionId, op, aid, wspId);
        return ev;
    }

    public ConsultManualSucceededEvent makeConsultManualSucceededEvent(long actionId, ArtifactId aid, Op op, Manual man) {
        long id = this.nextTimestamp.incrementAndGet();
        ConsultManualSucceededEvent ev = new ConsultManualSucceededEvent(id, actionId, op, aid, man);
        return ev;
    }

    public ObsArtListChangedEvent makeObsArtListChangedEvent(List<ObservableArtifactInfo> newFocused, List<ObservableArtifactInfo> noMoreFocused) {
        long id = this.nextTimestamp.incrementAndGet();
        ObsArtListChangedEvent ev = new ObsArtListChangedEvent(id, newFocused, noMoreFocused);
        return ev;
    }
}

