/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AbstractWorkspaceTopology;
import cartago.AgentId;
import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ICartagoController;
import cartago.ICartagoLogger;
import cartago.ICartagoLoggerManager;
import cartago.Op;
import cartago.OpId;
import cartago.WorkspaceId;
import cartago.WorkspaceKernel;
import cartago.security.AgentCredential;
import cartago.security.DefaultSecurityManager;
import cartago.security.IWorkspaceSecurityManager;
import cartago.security.SecurityException;

public class CartagoWorkspace {
    private WorkspaceKernel wspKernel;
    private boolean securityManagerEnabled = false;

    public CartagoWorkspace(WorkspaceId id) {
        this.wspKernel = new WorkspaceKernel(id, null);
    }

    public CartagoWorkspace(WorkspaceId id, ICartagoLogger logger) {
        this.wspKernel = new WorkspaceKernel(id, logger);
    }

    public WorkspaceId getId() {
        return this.wspKernel.getId();
    }

    public ICartagoContext join(AgentCredential cred, ICartagoCallback agentCallback) throws SecurityException, CartagoException {
        return this.wspKernel.joinWorkspace(cred, agentCallback);
    }

    public OpId execInterArtifactOp(ICartagoCallback callback, long agentCallbackId, AgentId uid, ArtifactId srcId, ArtifactId targetId, Op op, long timeout, IAlignmentTest test) throws CartagoException {
        return this.wspKernel.execInterArtifactOp(callback, agentCallbackId, uid, srcId, targetId, op, timeout, test);
    }

    public void enableSecurityManager() {
        this.wspKernel.setSecurityManager(new DefaultSecurityManager());
        this.securityManagerEnabled = true;
    }

    public void setSecurityManager(IWorkspaceSecurityManager man) {
        this.wspKernel.setSecurityManager(man);
        this.securityManagerEnabled = true;
    }

    public IWorkspaceSecurityManager getSecurityManager() throws SecurityException {
        if (this.securityManagerEnabled) {
            return this.wspKernel.getSecurityManager();
        }
        throw new SecurityException("No security manager enabled.");
    }

    public void registerLogger(ICartagoLogger logger) {
        this.wspKernel.getLoggerManager().registerLogger(logger);
    }

    public void unregisterLogger(ICartagoLogger logger) {
        this.wspKernel.getLoggerManager().unregisterLogger(logger);
    }

    public ICartagoController getController() {
        return this.wspKernel.getController();
    }

    public void setTopology(AbstractWorkspaceTopology topology) {
        this.wspKernel.setWSPTopology(topology);
    }

    public void setLoggerManager(ICartagoLoggerManager man) {
        this.wspKernel.setLoggerManager(man);
    }

    public ICartagoLoggerManager getLoggerManager() {
        return this.wspKernel.getLoggerManager();
    }

    public WorkspaceKernel getKernel() {
        return this.wspKernel;
    }
}

