/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.ArtifactId;
import cartago.CartagoEvent;
import cartago.CartagoException;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ICartagoListener;
import cartago.ICartagoSession;
import cartago.Op;
import cartago.WorkspaceId;
import cartago.events.JoinWSPSucceededEvent;
import cartago.events.QuitWSPSucceededEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class CartagoSession
implements ICartagoSession,
ICartagoCallback {
    private ConcurrentHashMap<WorkspaceId, ICartagoContext> contexts = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<CartagoEvent> perceptQueue = new ConcurrentLinkedQueue();
    private ICartagoListener agentArchListener;
    private AtomicLong actionId;

    CartagoSession(ICartagoListener listener) throws CartagoException {
        this.agentArchListener = listener;
        this.actionId = new AtomicLong(0L);
    }

    void setInitialContext(WorkspaceId wspId, ICartagoContext startContext) {
        this.contexts.put(wspId, startContext);
    }

    @Override
    public long doAction(ArtifactId aid, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        long actId = this.actionId.incrementAndGet();
        ICartagoContext ctx = null;
        ctx = this.contexts.get(aid.getWorkspaceId());
        if (ctx != null) {
            ctx.doAction(actId, aid, op, test, timeout);
            return actId;
        }
        throw new CartagoException("Wrong workspace.");
    }

    @Override
    public long doAction(Op op, IAlignmentTest test, long timeout) throws CartagoException {
        Map.Entry<WorkspaceId, ICartagoContext> c;
        ICartagoContext ctx;
        long actId = this.actionId.incrementAndGet();
        boolean found = false;
        Iterator<Map.Entry<WorkspaceId, ICartagoContext>> iterator = this.contexts.entrySet().iterator();
        while (iterator.hasNext() && !(found = (ctx = (c = iterator.next()).getValue()).doAction(actId, op, test, timeout))) {
        }
        if (found) {
            return actId;
        }
        throw new CartagoException("Artifact not found.");
    }

    @Override
    public long doAction(WorkspaceId wspId, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        long actId = this.actionId.incrementAndGet();
        ICartagoContext ctx = null;
        ctx = this.contexts.get(wspId);
        if (ctx != null) {
            ctx.doAction(actId, op, test, timeout);
            return actId;
        }
        throw new CartagoException("Wrong workspace.");
    }

    @Override
    public long doAction(String wspName, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        long actId = this.actionId.incrementAndGet();
        ICartagoContext ctx = null;
        for (Map.Entry<WorkspaceId, ICartagoContext> c : this.contexts.entrySet()) {
            if (!c.getKey().getName().equals(wspName)) continue;
            ctx = c.getValue();
            break;
        }
        if (ctx != null) {
            ctx.doAction(actId, op, test, timeout);
            return actId;
        }
        throw new CartagoException("Wrong workspace.");
    }

    @Override
    public long doAction(String wspName, Op op, String artName, IAlignmentTest test, long timeout) throws CartagoException {
        long actId = this.actionId.incrementAndGet();
        ICartagoContext ctx = null;
        for (Map.Entry<WorkspaceId, ICartagoContext> c : this.contexts.entrySet()) {
            if (!c.getKey().getName().equals(wspName)) continue;
            ctx = c.getValue();
            break;
        }
        if (ctx != null) {
            ctx.doAction(actId, artName, op, test, timeout);
            return actId;
        }
        throw new CartagoException("Wrong workspace.");
    }

    @Override
    public long doAction(WorkspaceId wspId, String artName, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        long actId = this.actionId.incrementAndGet();
        ICartagoContext ctx = null;
        ctx = this.contexts.get(wspId);
        if (ctx != null) {
            ctx.doAction(actId, artName, op, test, timeout);
            return actId;
        }
        throw new CartagoException("Wrong workspace.");
    }

    @Override
    public long doAction(Op op, String artName, IAlignmentTest test, long timeout) throws CartagoException {
        Map.Entry<WorkspaceId, ICartagoContext> c;
        ICartagoContext ctx;
        long actId = this.actionId.incrementAndGet();
        boolean found = false;
        Iterator<Map.Entry<WorkspaceId, ICartagoContext>> iterator = this.contexts.entrySet().iterator();
        while (iterator.hasNext() && !(found = (ctx = (c = iterator.next()).getValue()).doAction(actId, artName, op, test, timeout))) {
        }
        if (found) {
            return actId;
        }
        throw new CartagoException("Wrong workspace.");
    }

    @Override
    public List<WorkspaceId> getJoinedWorkspaces() throws CartagoException {
        LinkedList<WorkspaceId> wsps = new LinkedList<WorkspaceId>();
        for (Map.Entry<WorkspaceId, ICartagoContext> c : this.contexts.entrySet()) {
            wsps.add(c.getKey());
        }
        return wsps;
    }

    @Override
    public CartagoEvent fetchNextPercept() {
        return this.perceptQueue.poll();
    }

    private void checkWSPEvents(CartagoEvent ev) {
        if (ev instanceof JoinWSPSucceededEvent) {
            JoinWSPSucceededEvent wspev = (JoinWSPSucceededEvent)ev;
            this.contexts.put(wspev.getWorkspaceId(), wspev.getContext());
        } else if (ev instanceof QuitWSPSucceededEvent) {
            QuitWSPSucceededEvent wspev = (QuitWSPSucceededEvent)ev;
            this.contexts.remove(wspev.getWorkspaceId());
        }
    }

    @Override
    public void notifyCartagoEvent(CartagoEvent ev) {
        this.checkWSPEvents(ev);
        boolean keepEvent = true;
        if (this.agentArchListener != null) {
            keepEvent = this.agentArchListener.notifyCartagoEvent(ev);
        }
        if (keepEvent) {
            this.perceptQueue.add(ev);
        }
    }
}

