/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AgentId;
import cartago.ArtifactFactory;
import cartago.ArtifactId;
import cartago.CARTAGO_VERSION;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.CartagoNodeNotActiveException;
import cartago.CartagoSession;
import cartago.CartagoWorkspace;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ICartagoController;
import cartago.ICartagoListener;
import cartago.ICartagoLogger;
import cartago.ICartagoSession;
import cartago.NodeId;
import cartago.Op;
import cartago.OpId;
import cartago.WorkspaceId;
import cartago.infrastructure.CartagoInfrastructureLayerException;
import cartago.infrastructure.ICartagoInfrastructureLayer;
import cartago.security.AgentCredential;
import cartago.security.SecurityException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CartagoService {
    private static CartagoNode instance;
    private static Map<String, ICartagoInfrastructureLayer> infraLayers;
    private static String defaultInfraLayer;
    private static List<LinkedNodeInfo> linkedNodes;

    public static String getVersion() {
        return CARTAGO_VERSION.getID();
    }

    public static synchronized void startNode() throws CartagoException {
        if (instance != null) {
            throw new CartagoNodeNotActiveException();
        }
        instance = new CartagoNode();
    }

    public static synchronized void startNode(ICartagoLogger logger) throws CartagoException {
        if (instance != null) {
            throw new CartagoNodeNotActiveException();
        }
        instance = new CartagoNode(logger);
    }

    public static synchronized boolean isNodeActive() {
        return instance != null;
    }

    public static synchronized void shutdownNode() throws CartagoException {
        if (instance != null) {
            instance.shutdown();
            for (ICartagoInfrastructureLayer s : infraLayers.values()) {
                try {
                    s.shutdownLayer();
                    if (!s.isServiceRunning()) continue;
                    s.shutdownService();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            throw new CartagoNodeNotActiveException();
        }
        infraLayers.clear();
        instance = null;
    }

    public static synchronized void installInfrastructureLayer(String type) throws CartagoException {
        ICartagoInfrastructureLayer service;
        if (type.equals("default")) {
            type = defaultInfraLayer;
        }
        if ((service = infraLayers.get(type)) == null) {
            try {
                Class<?> serviceClass = Class.forName("cartago.infrastructure." + type + ".CartagoInfrastructureLayer");
                service = (ICartagoInfrastructureLayer)serviceClass.newInstance();
                infraLayers.put(type, service);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new CartagoException("Invalid infrastructure layer: " + type);
            }
        } else {
            throw new CartagoException("Infrastructure layer " + type + "already installed");
        }
    }

    public static void setDefaultInfrastructureLayer(String name) {
        defaultInfraLayer = name;
    }

    public static synchronized void startInfrastructureService(String type, String address) throws CartagoException {
        ICartagoInfrastructureLayer service;
        if (type.equals("default")) {
            type = defaultInfraLayer;
        }
        if ((service = infraLayers.get(type)) != null) {
            try {
                service.startService(instance, address);
            }
            catch (Exception ex) {
                throw new CartagoException("Infrastructure layer service failure: " + type);
            }
        } else {
            throw new CartagoException("Infrastructure layer " + type + "not installed");
        }
    }

    public static synchronized void startInfrastructureService(String type) throws CartagoException {
        CartagoService.startInfrastructureService(type, "");
    }

    public static synchronized ICartagoSession startSession(String wspName, AgentCredential cred, ICartagoListener eventListener) throws CartagoException {
        if (instance != null) {
            CartagoWorkspace wsp;
            if (wspName == null) {
                wspName = CartagoNode.MAIN_WSP_NAME;
            }
            if ((wsp = instance.getWorkspace(wspName)) == null) {
                throw new CartagoException("Unknown workspace " + wspName);
            }
            CartagoSession session = new CartagoSession(eventListener);
            ICartagoContext startContext = wsp.join(cred, session);
            WorkspaceId wspId = startContext.getWorkspaceId();
            session.setInitialContext(wspId, startContext);
            return session;
        }
        throw new CartagoNodeNotActiveException();
    }

    public static synchronized ICartagoSession startRemoteSession(String wspName, String wspAddress, String protocol, AgentCredential cred, ICartagoListener eventListener) throws CartagoException {
        if (wspName == null) {
            wspName = "default";
        }
        if (protocol == null || protocol.equals("default")) {
            protocol = defaultInfraLayer;
        }
        if (!infraLayers.containsKey(protocol)) {
            CartagoService.installInfrastructureLayer(protocol);
        }
        CartagoSession session = new CartagoSession(eventListener);
        ICartagoContext startContext = CartagoService.joinRemoteWorkspace(wspName, wspAddress, protocol, cred, session);
        WorkspaceId wspId = startContext.getWorkspaceId();
        session.setInitialContext(wspId, startContext);
        return session;
    }

    static synchronized ICartagoContext joinRemoteWorkspace(String wspName, String address, String protocol, AgentCredential cred, ICartagoCallback eventListener) throws SecurityException, CartagoException {
        try {
            if (protocol == null || protocol.equals("default")) {
                protocol = defaultInfraLayer;
            }
            ICartagoInfrastructureLayer service = infraLayers.get(protocol);
            ICartagoContext ctx = service.joinRemoteWorkspace(wspName, address, cred, eventListener);
            LinkedNodeInfo nodeInfo = new LinkedNodeInfo(ctx.getWorkspaceId().getNodeId(), protocol, address);
            boolean exists = false;
            for (LinkedNodeInfo tempNodeInfo : linkedNodes) {
                if (!tempNodeInfo.equals(nodeInfo)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                linkedNodes.add(nodeInfo);
            }
            return ctx;
        }
        catch (CartagoInfrastructureLayerException ex) {
            ex.printStackTrace();
            throw new CartagoException("Join " + wspName + "@" + address + " failed ");
        }
    }

    static OpId execRemoteInterArtifactOp(ICartagoCallback callback, long callbackId, AgentId userId, ArtifactId srcId, ArtifactId targetId, Op op, long timeout, IAlignmentTest test) throws CartagoInfrastructureLayerException, CartagoException {
        try {
            for (LinkedNodeInfo info : linkedNodes) {
                if (!targetId.getWorkspaceId().getNodeId().equals(info.getNodeId())) continue;
                String support = info.getProtocol();
                if (support == null || support.equals("default")) {
                    support = defaultInfraLayer;
                }
                ICartagoInfrastructureLayer service = infraLayers.get(support);
                return service.execRemoteInterArtifactOp(callback, callbackId, userId, srcId, targetId, info.getAddress(), op, timeout, test);
            }
            throw new CartagoException("Inter-artifact op failed: target node not linked");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CartagoException("Inter-artifact op failed: " + ex.getLocalizedMessage());
        }
    }

    public static synchronized void addArtifactFactory(String wspName, ArtifactFactory factory) throws CartagoException {
        if (instance != null) {
            if (wspName == null) {
                wspName = CartagoNode.MAIN_WSP_NAME;
            }
        } else {
            throw new CartagoNodeNotActiveException();
        }
        instance.getWorkspace(wspName).getKernel().addArtifactFactory(factory);
    }

    public static synchronized void removeArtifactFactory(String wspName, String name) throws CartagoException {
        if (instance != null) {
            if (wspName == null) {
                wspName = CartagoNode.MAIN_WSP_NAME;
            }
        } else {
            throw new CartagoNodeNotActiveException();
        }
        instance.getWorkspace(wspName).getKernel().removeArtifactFactory(name);
    }

    public static synchronized void registerLogger(String wspName, ICartagoLogger logger) throws CartagoException {
        if (instance == null) {
            throw new CartagoNodeNotActiveException();
        }
        instance.getWorkspace(wspName).registerLogger(logger);
    }

    public static synchronized void registerLoggerToRemoteWsp(String wspName, String address, String protocol, ICartagoLogger logger) throws CartagoException {
        try {
            if (protocol == null || protocol.equals("default")) {
                protocol = defaultInfraLayer;
            }
            ICartagoInfrastructureLayer service = infraLayers.get(protocol);
            service.registerLoggerToRemoteWsp(wspName, address, logger);
        }
        catch (CartagoInfrastructureLayerException ex) {
            ex.printStackTrace();
            throw new CartagoException("Registering logger at " + wspName + "@" + address + " failed ");
        }
    }

    public static synchronized void unregisterLogger(String wspName, ICartagoLogger logger) throws CartagoException {
        if (instance == null) {
            throw new CartagoNodeNotActiveException();
        }
        instance.getWorkspace(wspName).unregisterLogger(logger);
    }

    public static void enableLinkingWithNode(NodeId id, String support, String address) {
        linkedNodes.add(new LinkedNodeInfo(id, support, address));
    }

    public static ICartagoController getController(String wspName) throws CartagoException {
        if (instance != null) {
            return instance.getWorkspace(wspName).getController();
        }
        throw new CartagoNodeNotActiveException();
    }

    public static boolean isInfrastructureLayerInstalled(String protocol) {
        if (protocol.equals("default")) {
            protocol = defaultInfraLayer;
        }
        return infraLayers.get(protocol) != null;
    }

    public static void main(String[] args) {
        try {
            System.out.println("CArtAgO Infrastructure v." + CARTAGO_VERSION.getID() + " - DISI, University of Bologna, Italy.");
            CartagoService.startNode();
            CartagoService.installInfrastructureLayer("default");
            if (CartagoService.hasOption(args, "-infra")) {
                String address = CartagoService.getParam(args, "-address");
                if (address != null) {
                    CartagoService.startInfrastructureService("default", address);
                } else {
                    CartagoService.startInfrastructureService("default");
                }
            }
            System.out.println("Ready.");
        }
        catch (Exception ex) {
            System.err.println("Execution Failed: " + ex.getMessage());
        }
    }

    private static boolean hasOption(String[] args, String arg) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(arg) || i >= args.length - 1) continue;
            return true;
        }
        return false;
    }

    private static String getParam(String[] args, String arg) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(arg) || i >= args.length - 1) continue;
            return args[i + 1];
        }
        return null;
    }

    static {
        infraLayers = new HashMap<String, ICartagoInfrastructureLayer>();
        defaultInfraLayer = "rmi";
        linkedNodes = new LinkedList<LinkedNodeInfo>();
    }

    static class LinkedNodeInfo {
        NodeId nodeId;
        String protocol;
        String address;

        public LinkedNodeInfo(NodeId nodeId, String protocol, String address) {
            this.nodeId = nodeId;
            this.protocol = protocol;
            this.address = address;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getAddress() {
            return this.address;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof LinkedNodeInfo) {
                LinkedNodeInfo node = (LinkedNodeInfo)obj;
                return node.getNodeId().equals(this.getNodeId()) && node.getProtocol().equals(this.getProtocol());
            }
            return false;
        }
    }
}

