/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AbstractWorkspaceTopology;
import cartago.AgentId;
import cartago.ArtifactId;
import cartago.ArtifactNotAvailableException;
import cartago.CartagoException;
import cartago.CartagoNodeAlreadyActiveException;
import cartago.CartagoNodeNotActiveException;
import cartago.CartagoService;
import cartago.CartagoWorkspace;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoLogger;
import cartago.NodeId;
import cartago.Op;
import cartago.OpId;
import cartago.OpRequestTimeoutException;
import cartago.OperationUnavailableException;
import cartago.WorkspaceId;
import java.util.HashMap;

public class CartagoNode {
    private HashMap<String, CartagoWorkspace> wsps;
    private NodeId nodeId;
    private static CartagoNode instance;
    public static String MAIN_WSP_NAME;

    CartagoNode() throws CartagoException {
        if (instance != null) {
            throw new CartagoNodeAlreadyActiveException();
        }
        this.wsps = new HashMap();
        this.nodeId = new NodeId();
        this.createWorkspace(MAIN_WSP_NAME);
        instance = this;
    }

    CartagoNode(ICartagoLogger logger) throws CartagoException {
        if (instance != null) {
            throw new CartagoNodeAlreadyActiveException();
        }
        this.wsps = new HashMap();
        this.nodeId = new NodeId();
        this.createWorkspace(MAIN_WSP_NAME, logger);
        instance = this;
    }

    CartagoNode(AbstractWorkspaceTopology topology) throws CartagoException {
        if (instance != null) {
            throw new CartagoNodeAlreadyActiveException();
        }
        this.wsps = new HashMap();
        this.nodeId = new NodeId();
        this.createWorkspace(MAIN_WSP_NAME, topology);
        instance = this;
    }

    public synchronized CartagoWorkspace createWorkspace(String name) {
        CartagoWorkspace wsp = this.wsps.get(name);
        if (wsp == null) {
            WorkspaceId wid = new WorkspaceId(name, this.nodeId);
            wsp = new CartagoWorkspace(wid);
            this.wsps.put(name, wsp);
        }
        return wsp;
    }

    public synchronized CartagoWorkspace createWorkspace(String name, ICartagoLogger log) {
        CartagoWorkspace wsp = this.wsps.get(name);
        if (wsp == null) {
            WorkspaceId wid = new WorkspaceId(name, this.nodeId);
            wsp = new CartagoWorkspace(wid, log);
            this.wsps.put(name, wsp);
        }
        return wsp;
    }

    public synchronized CartagoWorkspace createWorkspace(String name, AbstractWorkspaceTopology topology) {
        CartagoWorkspace wsp = this.wsps.get(name);
        if (wsp == null) {
            WorkspaceId wid = new WorkspaceId(name, this.nodeId);
            wsp = new CartagoWorkspace(wid);
            wsp.setTopology(topology);
            this.wsps.put(name, wsp);
        }
        return wsp;
    }

    public synchronized CartagoWorkspace getWorkspace(String wspName) throws CartagoException {
        CartagoWorkspace env = this.wsps.get(wspName);
        if (env == null) {
            throw new CartagoException("Workspace not found.");
        }
        return env;
    }

    OpId execInterArtifactOp(ICartagoCallback ctx, long actionId, AgentId userId, ArtifactId srcId, ArtifactId targetId, Op op, long timeout, IAlignmentTest test) throws InterruptedException, OpRequestTimeoutException, OperationUnavailableException, ArtifactNotAvailableException, CartagoException {
        WorkspaceId targetWsp = targetId.getWorkspaceId();
        if (targetWsp.getNodeId().equals(this.nodeId)) {
            CartagoWorkspace wsp = this.wsps.get(targetWsp.getName());
            if (wsp == null) {
                throw new ArtifactNotAvailableException();
            }
            return wsp.execInterArtifactOp(ctx, actionId, userId, srcId, targetId, op, timeout, test);
        }
        return CartagoService.execRemoteInterArtifactOp(ctx, actionId, userId, srcId, targetId, op, timeout, test);
    }

    synchronized void shutdown() {
        for (CartagoWorkspace wsp : this.wsps.values()) {
            wsp.getKernel().shutdown();
        }
        instance = null;
    }

    public static CartagoNode getInstance() throws CartagoException {
        if (instance != null) {
            return instance;
        }
        throw new CartagoNodeNotActiveException();
    }

    public NodeId getId() {
        return this.nodeId;
    }

    static {
        MAIN_WSP_NAME = "main";
    }
}

