/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AgentId;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.ICartagoLogger;
import cartago.ICartagoLoggerManager;
import cartago.IEventFilter;
import cartago.Op;
import cartago.OpId;
import cartago.Tuple;
import java.util.Iterator;
import java.util.LinkedList;

class CartagoLoggerManager
implements ICartagoLoggerManager {
    private boolean isLogging = false;
    LinkedList<ICartagoLogger> loggers = new LinkedList();

    @Override
    public boolean isLogging() {
        return this.isLogging;
    }

    @Override
    public void registerLogger(ICartagoLogger logger) {
        this.loggers.add(logger);
        this.isLogging = true;
    }

    @Override
    public void unregisterLogger(ICartagoLogger logger) {
        this.loggers.remove(logger);
        if (this.loggers.size() == 0) {
            this.isLogging = false;
        }
    }

    @Override
    public void agentJoined(long when, AgentId id) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.agentJoined(when, id);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void agentQuit(long when, AgentId id) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.agentQuit(when, id);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void artifactCreated(long when, ArtifactId id, AgentId creator) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.artifactCreated(when, id, creator);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void artifactDisposed(long when, ArtifactId id, AgentId disposer) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.artifactDisposed(when, id, disposer);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void artifactFocussed(long when, AgentId who, ArtifactId id, IEventFilter ev) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.artifactFocussed(when, who, id, ev);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void artifactNoMoreFocussed(long when, AgentId who, ArtifactId id) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.artifactNoMoreFocussed(when, who, id);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void artifactsLinked(long when, AgentId id, ArtifactId linking, ArtifactId linked) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.artifactsLinked(when, id, linking, linked);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void newPercept(long when, ArtifactId aid, Tuple signal, ArtifactObsProperty[] added, ArtifactObsProperty[] removed, ArtifactObsProperty[] changed) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.newPercept(when, aid, signal, added, removed, changed);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void opCompleted(long when, OpId oid, ArtifactId aid, Op op) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.opCompleted(when, oid, aid, op);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void opFailed(long when, OpId oid, ArtifactId aid, Op op, String msg, Tuple descr) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.opFailed(when, oid, aid, op, msg, descr);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void opRequested(long when, AgentId who, ArtifactId aid, Op op) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.opRequested(when, who, aid, op);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void opResumed(long when, OpId oid, ArtifactId aid, Op op) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.opResumed(when, oid, aid, op);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void opStarted(long when, OpId oid, ArtifactId aid, Op op) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.opStarted(when, oid, aid, op);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }

    @Override
    public void opSuspended(long when, OpId oid, ArtifactId aid, Op op) {
        Iterator it = this.loggers.iterator();
        while (it.hasNext()) {
            ICartagoLogger l = (ICartagoLogger)it.next();
            try {
                l.opSuspended(when, oid, aid, op);
            }
            catch (Exception ex) {
                it.remove();
            }
        }
    }
}

