/*
 * Decompiled with CFR 0.152.
 */
package cartago;

class BoundedBuffer {
    private int in = 0;
    private int out = 0;
    private int count = 0;
    private Object[] buffer;

    public BoundedBuffer(int size) {
        this.buffer = new Object[size];
    }

    public synchronized void insert(Object item) throws InterruptedException {
        while (this.isFull()) {
            this.wait();
        }
        ++this.count;
        this.buffer[this.in] = item;
        this.in = (this.in + 1) % this.buffer.length;
        this.notifyAll();
    }

    public synchronized Object remove() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
        Object item = this.buffer[this.out];
        this.out = (this.out + 1) % this.buffer.length;
        --this.count;
        this.notifyAll();
        return item;
    }

    private boolean isEmpty() {
        return this.count == 0;
    }

    private boolean isFull() {
        return this.count == this.buffer.length;
    }
}

