/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AbstractArtifactAdapter;
import cartago.AgentId;
import cartago.Artifact;
import cartago.ArtifactObserver;
import cartago.CartagoEvent;
import cartago.ICartagoCallback;
import cartago.IEventFilter;
import cartago.events.ArtifactObsEvent;
import java.util.ArrayList;
import java.util.Iterator;

public class ArtifactDescriptor {
    private Artifact artifact;
    private AgentId creator;
    private AbstractArtifactAdapter adapter;
    private boolean observed;
    private ArrayList<ArtifactObserver> observers;

    public ArtifactDescriptor(Artifact artifact, AgentId creator, AbstractArtifactAdapter adapter) {
        this.artifact = artifact;
        this.adapter = adapter;
        this.creator = creator;
        this.observers = new ArrayList();
        this.observed = false;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public AgentId getAgentCreator() {
        return this.creator;
    }

    public String getArtifactType() {
        return this.artifact.getClass().getCanonicalName();
    }

    public AbstractArtifactAdapter getAdapter() {
        return this.adapter;
    }

    public synchronized void removeAllObservers() {
        this.observers.clear();
    }

    public synchronized void addObserver(AgentId id, IEventFilter ev, ICartagoCallback ctx) {
        ArtifactObserver obs;
        Iterator<ArtifactObserver> it = this.observers.iterator();
        boolean found = false;
        while (it.hasNext()) {
            obs = it.next();
            if (!obs.getAgentId().equals(id)) continue;
            found = true;
            break;
        }
        if (!found) {
            obs = new ArtifactObserver(id, ev, ctx);
            this.observers.add(obs);
            this.observed = true;
        }
    }

    public synchronized boolean removeObserver(AgentId ctxId) {
        Iterator<ArtifactObserver> it = this.observers.iterator();
        boolean found = false;
        while (it.hasNext()) {
            ArtifactObserver obs = it.next();
            if (!obs.getAgentId().equals(ctxId)) continue;
            it.remove();
            found = true;
            break;
        }
        if (found && this.observers.size() == 0) {
            this.observed = false;
        }
        return found;
    }

    public synchronized boolean isObserved() {
        return this.observed;
    }

    public synchronized boolean isObservedBy(AgentId userId) {
        Iterator<ArtifactObserver> it = this.observers.iterator();
        if (this.observed) {
            while (it.hasNext()) {
                ArtifactObserver obs = it.next();
                if (!obs.getAgentId().equals(userId)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void notifyObservers(CartagoEvent ev) {
        if (this.observed) {
            for (ArtifactObserver obs : this.observers) {
                try {
                    IEventFilter filter = obs.getFilter();
                    if (filter == null) {
                        obs.getListener().notifyCartagoEvent(ev);
                        continue;
                    }
                    try {
                        boolean res;
                        if (!(ev instanceof ArtifactObsEvent) || !(res = filter.select((ArtifactObsEvent)ev))) continue;
                        obs.getListener().notifyCartagoEvent(ev);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public synchronized void notifyObserver(AgentId id, CartagoEvent ev) {
        if (this.observed) {
            for (ArtifactObserver obs : this.observers) {
                try {
                    if (!obs.getAgentId().equals(id)) continue;
                    IEventFilter filter = obs.getFilter();
                    if (filter == null) {
                        obs.getListener().notifyCartagoEvent(ev);
                        break;
                    }
                    try {
                        boolean res;
                        if (!(ev instanceof ArtifactObsEvent) || !(res = filter.select((ArtifactObsEvent)ev))) break;
                        obs.getListener().notifyCartagoEvent(ev);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

