/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.ARTIFACT_INFO;
import cartago.AbstractArtifactAdapter;
import cartago.AbstractWorkspacePoint;
import cartago.AgentId;
import cartago.ArtifactConfig;
import cartago.ArtifactGuardMethod;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.ArtifactOpMethod;
import cartago.ArtifactOutPort;
import cartago.CartagoException;
import cartago.CartagoNode;
import cartago.GUARD;
import cartago.IAlignmentTest;
import cartago.IArtifactGuard;
import cartago.IArtifactOp;
import cartago.IBlockingCmd;
import cartago.ICartagoLoggerManager;
import cartago.INTERNAL_OPERATION;
import cartago.InterArtifactCallback;
import cartago.LINK;
import cartago.Manual;
import cartago.OPERATION;
import cartago.OUTPORT;
import cartago.ObsPropMap;
import cartago.ObsProperty;
import cartago.Op;
import cartago.OpDescriptor;
import cartago.OpExecutionFrame;
import cartago.OpFeedbackParam;
import cartago.OpId;
import cartago.OperationException;
import cartago.OperationFailedException;
import cartago.OperationInfo;
import cartago.PendingOp;
import cartago.Tuple;
import cartago.UnknownArtifactException;
import cartago.WorkspaceKernel;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public abstract class Artifact {
    private ArtifactId id;
    WorkspaceKernel env;
    protected OpId thisOpId;
    private OpExecutionFrame opExecFrame;
    private ArrayList<OpExecutionFrame> opsInExecution;
    private HashMap<String, Method> guardMap;
    private HashMap<String, OpDescriptor> operationMap;
    private int obsPropId;
    private ObsPropMap obsPropertyMap;
    private HashMap<String, ArtifactOutPort> outPortsMap;
    private ReentrantLock lock;
    private Condition guards;
    private InterArtifactCallback opCallback;
    private Manual manual;
    private AtomicInteger opIds;
    private AgentId creatorId;
    protected AbstractWorkspacePoint position;
    protected double observabilityRadius;

    final void bind(ArtifactId id, AgentId creatorId, WorkspaceKernel env) throws CartagoException {
        this.id = id;
        this.creatorId = creatorId;
        this.env = env;
        this.obsPropId = 0;
        this.opIds = new AtomicInteger(0);
        this.lock = new ReentrantLock(true);
        this.guards = this.lock.newCondition();
        this.opsInExecution = new ArrayList();
        this.guardMap = new HashMap();
        this.operationMap = new HashMap();
        this.outPortsMap = new HashMap();
        this.obsPropertyMap = new ObsPropMap();
        this.opCallback = new InterArtifactCallback(this.lock);
        if (this.getClass().isAnnotationPresent(ARTIFACT_INFO.class)) {
            ARTIFACT_INFO info = this.getClass().getAnnotation(ARTIFACT_INFO.class);
            for (OUTPORT port : info.outports()) {
                this.outPortsMap.put(port.name(), new ArtifactOutPort(port.name()));
            }
        }
        try {
            this.setupOperations();
        }
        catch (CartagoException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void setupOperations() throws CartagoException {
        for (Class<?> c = this.getClass(); c != null; c = c.getSuperclass()) {
            Method[] methods;
            for (Method m : methods = c.getDeclaredMethods()) {
                OpDescriptor opdesc;
                String name;
                Method guardMethod;
                ArtifactGuardMethod guardBody;
                String guard;
                Annotation op;
                if (m.isAnnotationPresent(OPERATION.class)) {
                    op = m.getAnnotation(OPERATION.class);
                    guard = op.guard();
                    guardBody = null;
                    if (!guard.equals("")) {
                        guardMethod = this.getMethodInHierarchy(guard, m.getParameterTypes());
                        if (guardMethod == null) {
                            throw new CartagoException("invalid guard: " + guard);
                        }
                        guardBody = new ArtifactGuardMethod(this, guardMethod);
                    }
                    name = null;
                    name = !m.isVarArgs() ? Artifact.getOpKey(m.getName(), m.getParameterTypes().length) : Artifact.getOpKey(m.getName(), -1);
                    opdesc = new OpDescriptor(name, new ArtifactOpMethod(this, m), guardBody, OpDescriptor.OpType.UI);
                    this.operationMap.put(name, opdesc);
                    continue;
                }
                if (m.isAnnotationPresent(LINK.class)) {
                    op = m.getAnnotation(LINK.class);
                    guard = op.guard();
                    guardBody = null;
                    if (!guard.equals("")) {
                        guardMethod = this.getMethodInHierarchy(guard, m.getParameterTypes());
                        if (guardMethod == null) {
                            throw new CartagoException("invalid guard: " + guard);
                        }
                        guardBody = new ArtifactGuardMethod(this, guardMethod);
                    }
                    name = Artifact.getOpKey(m.getName(), m.getParameterTypes().length);
                    opdesc = new OpDescriptor(name, new ArtifactOpMethod(this, m), guardBody, OpDescriptor.OpType.LINK);
                    this.operationMap.put(name, opdesc);
                    continue;
                }
                if (m.isAnnotationPresent(INTERNAL_OPERATION.class)) {
                    op = m.getAnnotation(INTERNAL_OPERATION.class);
                    guard = op.guard();
                    guardBody = null;
                    if (!guard.equals("")) {
                        guardMethod = this.getMethodInHierarchy(guard, m.getParameterTypes());
                        if (guardMethod == null) {
                            throw new CartagoException("invalid guard: " + guard);
                        }
                        guardBody = new ArtifactGuardMethod(this, guardMethod);
                    }
                    name = Artifact.getOpKey(m.getName(), m.getParameterTypes().length);
                    opdesc = new OpDescriptor(name, new ArtifactOpMethod(this, m), guardBody, OpDescriptor.OpType.INTERNAL);
                    this.operationMap.put(name, opdesc);
                    continue;
                }
                if (!m.isAnnotationPresent(GUARD.class)) continue;
                String name2 = Artifact.getOpKey(m.getName(), m.getParameterTypes().length);
                this.guardMap.put(name2, m);
            }
        }
    }

    public static String getManualSrcFile(String artType) throws UnknownArtifactException {
        try {
            Class<?> cl = Class.forName(artType);
            if (cl.isAnnotationPresent(ARTIFACT_INFO.class)) {
                ARTIFACT_INFO info = cl.getAnnotation(ARTIFACT_INFO.class);
                return info.manual_file();
            }
            return "";
        }
        catch (Exception ex) {
            throw new UnknownArtifactException(artType);
        }
    }

    public static String getOpKey(String opName, int nargs) {
        if (nargs >= 0) {
            return opName + "/" + nargs;
        }
        return opName + "/_";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit(ArtifactConfig cfg) throws CartagoException {
        block7: {
            try {
                this.lock.lock();
                Method m = this.getMethodInHierarchy2("init", cfg.getTypes());
                if (m != null) {
                    try {
                        m.setAccessible(true);
                        m.invoke((Object)this, cfg.getValues());
                        this.commitObsStateChanges();
                        break block7;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.obsPropertyMap.rollbackChanges();
                        throw new CartagoException("init_failed");
                    }
                }
                if (cfg.getTypes().length > 0) {
                    throw new CartagoException("init_failed");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private Method getMethodInHierarchy(String name, Class<?>[] types) {
        Class<?> cl = this.getClass();
        while (true) {
            try {
                return cl.getDeclaredMethod(name, types);
            }
            catch (Exception ex) {
                if ((cl = cl.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    private Method getMethodInHierarchy2(String name, Class<?>[] types) {
        Class<?> cl = this.getClass();
        do {
            Method[] methods;
            for (Method m : methods = cl.getDeclaredMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != types.length) continue;
                return m;
            }
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOperation(OpExecutionFrame info) throws CartagoException {
        ICartagoLoggerManager log = this.env.getLoggerManager();
        try {
            Tuple desc;
            Object[] params;
            IArtifactOp opBody;
            Op op;
            block44: {
                boolean aligned;
                this.lock.lock();
                op = info.getOperation();
                String name = op.getName();
                OpDescriptor opDesc = this.operationMap.get(Artifact.getOpKey(name, op.getParamValues().length));
                boolean varargs = false;
                if (opDesc == null) {
                    opDesc = this.operationMap.get(Artifact.getOpKey(name, -1));
                    if (opDesc == null) {
                        if (!info.isInternalOp()) {
                            String msg = "Unknown operation " + name + " on artifact " + this.id + " (type " + this.id.getArtifactType() + ")";
                            Tuple desc2 = new Tuple("unknown_operation", this.id, name);
                            if (log.isLogging()) {
                                log.opFailed(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation(), msg, desc2);
                            }
                            info.notifyOpFailed(msg, desc2);
                        }
                        return;
                    }
                    varargs = true;
                }
                IAlignmentTest test = info.getAlignmentTest();
                opBody = null;
                IArtifactGuard guardBody = null;
                opBody = opDesc.getOp();
                guardBody = opDesc.getGuard();
                params = null;
                if (!varargs) {
                    params = op.getParamValues();
                } else {
                    int i;
                    Object[] flat = op.getParamValues();
                    int len = opBody.getNumParameters();
                    params = new Object[len];
                    int var = flat.length - len + 1;
                    Object[] varlist = new Object[var];
                    for (i = 0; i < len - 1; ++i) {
                        params[i] = flat[i];
                    }
                    params[len - 1] = varlist;
                    for (i = 0; i < var; ++i) {
                        varlist[i] = flat[len - 1 + i];
                    }
                }
                if (log.isLogging()) {
                    log.opStarted(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation());
                }
                boolean guardOK = true;
                if (guardBody != null) {
                    guardOK = guardBody.eval(params);
                    while (!guardOK) {
                        this.guards.await();
                        guardOK = guardBody.eval(params);
                    }
                }
                if (test == null || (aligned = test.match(this.obsPropertyMap))) break block44;
                String msg = "Test alignment failed";
                desc = new Tuple("not_aligned");
                if (log.isLogging()) {
                    log.opFailed(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation(), msg, desc);
                }
                info.notifyOpFailed(msg, desc);
                return;
            }
            try {
                this.opsInExecution.add(info);
                this.opExecFrame = info;
                this.thisOpId = this.opExecFrame.getOpId();
                try {
                    try {
                        opBody.exec(params);
                        this.commitObsStateChanges();
                    }
                    catch (InvocationTargetException ex) {
                        if (!(ex.getTargetException() instanceof OperationFailedException)) {
                            ex.printStackTrace();
                            throw ex;
                        }
                    }
                    finally {
                        this.opsInExecution.remove(info);
                    }
                    if (!info.isInternalOp() | info.getActionId() == -2L) {
                        if (!info.isFailed()) {
                            if (log.isLogging()) {
                                log.opCompleted(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation());
                            }
                            if (!info.completionNotified()) {
                                info.notifyOpCompletion();
                            }
                        } else {
                            String msg = info.getFailureMsg();
                            Tuple desc3 = info.getFailureReason();
                            if (log.isLogging()) {
                                log.opFailed(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation(), msg, desc3);
                            }
                            this.obsPropertyMap.rollbackChanges();
                            info.notifyOpFailed();
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    StringBuffer msg = new StringBuffer("Wrong operation arguments: operation " + op.getName() + " on artifact " + this.id + " (type: " + this.id.getArtifactType() + ")\n" + "- expected " + ((ArtifactOpMethod)opBody).getMethod().getParameterTypes().length + " parameter(s) - types: ");
                    int n = 0;
                    for (Class<?> clazz : ((ArtifactOpMethod)opBody).getMethod().getParameterTypes()) {
                        if (n != 0) {
                            msg.append(", ");
                        }
                        msg.append("" + clazz);
                        ++n;
                    }
                    msg.append("\n- actual parameter(s): ");
                    n = 0;
                    for (Object object : params) {
                        if (n != 0) {
                            msg.append(", ");
                        }
                        msg.append("" + object + " type: " + object.getClass());
                        ++n;
                    }
                    Tuple desc4 = new Tuple("wrong_op_arguments", this.id, opBody.getName() + "/" + opBody.getNumParameters());
                    if (log.isLogging()) {
                        log.opFailed(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation(), msg.toString(), desc4);
                    }
                    if (!info.isInternalOp()) {
                        info.setFailed(msg.toString(), desc4);
                        info.notifyOpFailed();
                    }
                }
                catch (Exception ex) {
                    String msg = "Unknown Operation";
                    desc = new Tuple("unknown_operation", opBody.getName() + "/" + opBody.getNumParameters());
                    if (log.isLogging()) {
                        log.opFailed(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation(), msg, desc);
                    }
                    if (!info.isInternalOp()) {
                        info.setFailed(msg, desc);
                        info.notifyOpFailed();
                    }
                }
            }
            catch (Exception ex) {
                String msg = "Artifact internal error";
                Tuple desc5 = new Tuple("internal_error", opBody.getName() + "/" + opBody.getNumParameters());
                if (log.isLogging()) {
                    log.opFailed(System.currentTimeMillis(), info.getOpId(), this.id, info.getOperation(), msg, desc5);
                }
                info.setFailed(msg, desc5);
                info.notifyOpFailed();
            }
        }
        finally {
            this.guards.signalAll();
            this.lock.unlock();
        }
    }

    private void restoreOpExecContext(OpId id) {
        this.thisOpId = id;
        boolean found = false;
        for (OpExecutionFrame frame : this.opsInExecution) {
            if (!frame.getOpId().equals(id)) continue;
            this.opExecFrame = frame;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("INTERNAL ERROR: Op Exec Context cannot be restored.");
        }
    }

    private void commitObsStateChanges() {
        ArtifactObsProperty[] changed = this.obsPropertyMap.getPropsChanged();
        ArtifactObsProperty[] added = this.obsPropertyMap.getPropsAdded();
        ArtifactObsProperty[] removed = this.obsPropertyMap.getPropsRemoved();
        try {
            if (changed != null || added != null || removed != null) {
                this.env.notifyObsEvent(this.id, null, changed, added, removed);
                this.guards.signalAll();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.obsPropertyMap.commitChanges();
    }

    private void commitObsStateChangesAndSignal(AgentId target, Tuple signal) {
        ArtifactObsProperty[] changed = this.obsPropertyMap.getPropsChanged();
        ArtifactObsProperty[] added = this.obsPropertyMap.getPropsAdded();
        ArtifactObsProperty[] removed = this.obsPropertyMap.getPropsRemoved();
        try {
            if (target == null) {
                this.env.notifyObsEvent(this.id, signal, changed, added, removed);
            } else {
                this.env.notifyObsEventToAgent(this.id, target, signal, changed, added, removed);
            }
            this.guards.signalAll();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.obsPropertyMap.commitChanges();
    }

    @OPERATION
    void observeProperty(String name, OpFeedbackParam<ArtifactObsProperty> prop) {
        ObsProperty p = this.obsPropertyMap.getByName(name);
        if (p != null) {
            prop.set(p.getUserCopy());
        } else {
            this.failed("Property not found " + name);
        }
    }

    protected ArtifactId getId() {
        return this.id;
    }

    OpExecutionFrame getOpFrame() {
        return this.opExecFrame;
    }

    protected AgentId getCurrentOpAgentId() {
        return this.opExecFrame.getAgentId();
    }

    protected ArtifactId getCurrentOpAgentBody() {
        return this.env.getAgentBodyArtifact(this.opExecFrame.getAgentId());
    }

    protected void commit() {
        this.commitObsStateChanges();
    }

    protected void signal(String type, Object ... objs) {
        try {
            this.commitObsStateChangesAndSignal(null, new Tuple(type, objs));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Error in generating the event.");
        }
    }

    protected void signal(AgentId target, String type, Object ... objs) {
        try {
            this.commitObsStateChangesAndSignal(target, new Tuple(type, objs));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Error in generating the event.");
        }
    }

    protected void failed(String reason) {
        this.opExecFrame.setFailed(reason, null);
        throw new OperationFailedException();
    }

    protected void failed(String reason, String tupleDesc, Object ... params) {
        this.opExecFrame.setFailed(reason, new Tuple(tupleDesc, params));
        throw new OperationFailedException();
    }

    protected void defineObsProperty(String name, Object ... values) {
        try {
            String fullId = "obs_id_" + this.env.getId().getId() + this.id.getId() + "_" + this.obsPropId;
            ObsProperty prop = new ObsProperty(this.obsPropertyMap, this.obsPropId, fullId, name, values);
            this.obsPropertyMap.add(prop);
            ++this.obsPropId;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("invalid observable property: " + name);
        }
    }

    protected void removeObsProperty(String name) {
        ObsProperty prop = this.obsPropertyMap.removeByName(name);
        if (prop == null) {
            throw new IllegalArgumentException("invalid observable property: " + name);
        }
    }

    protected void removeObsPropertyByTemplate(String name, Object ... values) {
        ObsProperty prop = this.obsPropertyMap.remove(name, values);
        if (prop == null) {
            throw new IllegalArgumentException("invalid observable property: " + name);
        }
    }

    protected ObsProperty getObsProperty(String name) {
        return this.obsPropertyMap.getByName(name);
    }

    protected boolean hasObsProperty(String name) {
        return this.obsPropertyMap.getByName(name) != null;
    }

    protected ObsProperty getObsPropertyByTemplate(String name, Object ... values) {
        return this.obsPropertyMap.get(name, values);
    }

    protected boolean hasObsPropertyByTemplate(String name, Object ... values) {
        return this.obsPropertyMap.get(name, values) != null;
    }

    protected void updateObsProperty(String name, Object ... values) {
        this.getObsProperty(name).updateValues(values);
    }

    protected void await(String guardName, Object ... params) {
        ICartagoLoggerManager log = this.env.getLoggerManager();
        OpId id = this.thisOpId;
        try {
            this.commitObsStateChanges();
            String name = Artifact.getOpKey(guardName, params.length);
            Method guard = this.guardMap.get(name);
            guard.setAccessible(true);
            boolean guardOK = (Boolean)guard.invoke((Object)this, params);
            while (!guardOK) {
                this.guards.await();
                guardOK = (Boolean)guard.invoke((Object)this, params);
            }
            this.restoreOpExecContext(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Exception in await " + guardName);
        }
    }

    protected void await_time(long dt) {
        OpId id = this.thisOpId;
        try {
            this.commitObsStateChanges();
            this.lock.unlock();
            Thread.sleep(dt);
            this.lock.lock();
            this.restoreOpExecContext(id);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception in await " + dt);
        }
    }

    protected void await(IBlockingCmd cmd) {
        OpId id = this.thisOpId;
        try {
            this.commitObsStateChanges();
            this.lock.unlock();
            cmd.exec();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception in await " + cmd);
        }
        finally {
            this.lock.lock();
            this.restoreOpExecContext(id);
        }
    }

    protected void execInternalOp(String opName, Object ... params) {
        try {
            this.env.doInternalOp(this.id, new Op(opName, params));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Error in executing internal op.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execLinkedOp(String outPortName, String opName, Object ... params) throws OperationException {
        OpId id = this.thisOpId;
        ArtifactOutPort port = this.outPortsMap.get(outPortName);
        if (port == null) {
            throw new OperationException("Wrong out port name.");
        }
        if (port.getArtifactList().isEmpty()) {
            throw new OperationException("No artifact linked.");
        }
        ArrayList<PendingOp> popList = new ArrayList<PendingOp>();
        for (ArtifactId aid : port.getArtifactList()) {
            try {
                PendingOp pop = this.opCallback.createPendingOp();
                AgentId userId = this.getCurrentOpAgentId();
                Op op = new Op(opName, params);
                CartagoNode.getInstance().execInterArtifactOp(this.opCallback, pop.getActionId(), userId, this.getId(), aid, op, Integer.MAX_VALUE, null);
                popList.add(pop);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new OperationException("execLinkedOp failed " + ex);
            }
        }
        try {
            this.commitObsStateChanges();
            this.lock.unlock();
            for (PendingOp pop : popList) {
                pop.waitForCompletion();
                if (pop.hasSucceeded()) continue;
                throw new OperationException("op failed.");
            }
        }
        finally {
            this.lock.lock();
            this.restoreOpExecContext(id);
        }
    }

    protected boolean isLinked(String outPortName) {
        ArtifactOutPort port = this.outPortsMap.get(outPortName);
        if (port == null) {
            return false;
        }
        return !port.getArtifactList().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execLinkedOp(ArtifactId aid, String opName, Object ... params) throws OperationException {
        OpId id = this.thisOpId;
        try {
            PendingOp pop = this.opCallback.createPendingOp();
            AgentId userId = this.getCurrentOpAgentId();
            Op op = new Op(opName, params);
            CartagoNode.getInstance().execInterArtifactOp(this.opCallback, pop.getActionId(), userId, this.getId(), aid, op, Integer.MAX_VALUE, null);
            try {
                this.commitObsStateChanges();
                this.lock.unlock();
                pop.waitForCompletion();
            }
            finally {
                this.lock.lock();
                this.restoreOpExecContext(id);
            }
            if (!pop.hasSucceeded()) {
                throw new OperationException("op failed.");
            }
        }
        catch (Exception ex) {
            throw new OperationException("execLinkedOp failed " + ex);
        }
    }

    protected ArtifactId makeArtifact(String name, String type, ArtifactConfig params) throws OperationException {
        try {
            return this.env.makeArtifact(this.getCurrentOpAgentId(), name, type, params);
        }
        catch (Exception ex) {
            throw new OperationException("makeArtifact failed: " + name + " " + type);
        }
    }

    protected void dispose(ArtifactId aid) throws OperationException {
        try {
            this.env.disposeArtifact(this.getCurrentOpAgentId(), this.id);
        }
        catch (Exception ex) {
            throw new OperationException("disposeArtifact failed: " + aid);
        }
    }

    protected ArtifactId lookupArtifact(String name) throws OperationException {
        try {
            return this.env.lookupArtifact(this.getCurrentOpAgentId(), name);
        }
        catch (Exception ex) {
            throw new OperationException("lookupArtifact failed: " + name);
        }
    }

    protected void delay(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void log(String msg) {
        System.out.println("[" + this.getId().getName() + "] " + msg);
    }

    protected void defineOp(IArtifactOp op, IArtifactGuard guard) {
        String name = null;
        name = !op.isVarArgs() ? Artifact.getOpKey(op.getName(), op.getNumParameters()) : Artifact.getOpKey(op.getName(), -1);
        OpDescriptor opdesc = new OpDescriptor(name, op, guard, OpDescriptor.OpType.UI);
        this.operationMap.put(name, opdesc);
    }

    protected void dispose() {
    }

    protected void setupPosition(AbstractWorkspacePoint pos, double observabilityRadius) {
        this.position = pos;
        this.observabilityRadius = observabilityRadius;
        try {
            this.env.notifyArtifactPositionOrRadiusChange(this.id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updatePosition(AbstractWorkspacePoint pos) {
        this.position = pos;
        try {
            this.env.notifyArtifactPositionOrRadiusChange(this.id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void updateObservabilityRadius(double radius) {
        this.observabilityRadius = radius;
        try {
            this.env.notifyArtifactPositionOrRadiusChange(this.id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected final AbstractWorkspacePoint getPosition() {
        return this.position;
    }

    protected final double getObservabilityRadius() {
        return this.observabilityRadius;
    }

    protected AgentId getCreatorId() {
        return this.creatorId;
    }

    public void beginExternalSession() {
        try {
            this.lock.lock();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void endExternalSession(boolean success) {
        try {
            if (success) {
                this.commitObsStateChanges();
            } else {
                this.obsPropertyMap.rollbackChanges();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.guards.signalAll();
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linkTo(ArtifactId aid, String outPort) throws CartagoException {
        ArtifactOutPort port = null;
        HashMap<String, ArtifactOutPort> hashMap = this.outPortsMap;
        synchronized (hashMap) {
            if (outPort == null) {
                Iterator<ArtifactOutPort> it = this.outPortsMap.values().iterator();
                if (it.hasNext()) {
                    port = it.next();
                }
            } else {
                port = this.outPortsMap.get(outPort);
            }
            if (port == null) {
                throw new CartagoException("Invalid out port: " + outPort);
            }
            port.addArtifact(aid);
        }
    }

    private List<ArtifactObsProperty> readProperties() {
        return this.obsPropertyMap.readAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OpDescriptor> getOperations() throws CartagoException {
        try {
            ArrayList<OpDescriptor> list = new ArrayList<OpDescriptor>();
            HashMap<String, OpDescriptor> hashMap = this.operationMap;
            synchronized (hashMap) {
                for (OpDescriptor op : this.operationMap.values()) {
                    list.add(op);
                }
                return list;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OperationInfo> getOpInExecution() {
        try {
            ArrayList<OpExecutionFrame> arrayList = this.opsInExecution;
            synchronized (arrayList) {
                ArrayList<OperationInfo> opInfo = new ArrayList<OperationInfo>();
                for (OpExecutionFrame op : this.opsInExecution) {
                    int id = op.getOpId().getId();
                    String name = op.getOpId().getOpName();
                    opInfo.add(new OperationInfo(id, name));
                }
                return opInfo;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    AbstractArtifactAdapter getAdapter() {
        return new ArtifactAdapter(this);
    }

    OpId getFreshId(String opName, AgentId ctxId) {
        int opid = this.opIds.getAndIncrement();
        OpId oid = new OpId(this.id, opName, opid, ctxId);
        return oid;
    }

    public abstract class AbstractAsyncProcess
    extends Thread
    implements IBlockingCmd {
        @Override
        public final void exec() {
            try {
                this.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void signal(String type, Object ... objs) {
            try {
                Artifact.this.lock.lock();
                Artifact.this.commitObsStateChangesAndSignal(null, new Tuple(type, objs));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                Artifact.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void signal(AgentId target, String type, Object ... objs) {
            try {
                Artifact.this.lock.lock();
                Artifact.this.commitObsStateChangesAndSignal(target, new Tuple(type, objs));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                Artifact.this.lock.unlock();
            }
        }
    }

    class ArtifactAdapter
    extends AbstractArtifactAdapter {
        public ArtifactAdapter(Artifact art) {
            super(art);
        }

        @Override
        public ArtifactObsProperty readProperty(String propertyName) throws CartagoException {
            return this.artifact.getObsProperty(propertyName).getUserCopy();
        }

        @Override
        public List<ArtifactObsProperty> readProperties() {
            return this.artifact.readProperties();
        }

        @Override
        public void initArtifact(ArtifactConfig cfg) throws CartagoException {
            this.artifact.doInit(cfg);
        }

        @Override
        public void doOperation(OpExecutionFrame info) throws CartagoException {
            this.artifact.doOperation(info);
        }

        @Override
        public AbstractWorkspacePoint getPosition() {
            return this.artifact.position;
        }

        @Override
        public double getObservabilityRadius() {
            return Artifact.this.observabilityRadius;
        }

        @Override
        public Manual getManual() {
            return this.artifact.manual;
        }

        @Override
        public void linkTo(ArtifactId aid, String portName) throws CartagoException {
            this.artifact.linkTo(aid, portName);
        }

        @Override
        public List<OpDescriptor> getOperations() throws CartagoException {
            return this.artifact.getOperations();
        }

        @Override
        public List<OperationInfo> getOpInExecution() {
            return this.artifact.getOpInExecution();
        }

        @Override
        public boolean hasOperation(Op op) {
            String name = Artifact.getOpKey(op.getName(), op.getParamValues().length);
            return this.artifact.operationMap.containsKey(name);
        }
    }
}

