/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AbstractWorkspacePoint;
import cartago.AgentBody;
import cartago.Artifact;
import cartago.ArtifactId;
import cartago.OPERATION;

public class AgentBodyArtifact
extends Artifact {
    protected double observingRadius;
    private AgentBody body;

    @OPERATION
    void init(AgentBody body) {
        this.body = body;
        this.defineObsProperty("joined_wsp", body.getWorkspaceId().getName(), body.getWorkspaceId());
    }

    protected void setupPosition(AbstractWorkspacePoint pos, double observabilityRadius, double observingRadius) {
        this.position = pos;
        this.observabilityRadius = observabilityRadius;
        this.observingRadius = observingRadius;
        this.env.bindAgentBodyArtifact(this.getCreatorId(), this);
        try {
            this.env.notifyArtifactPositionOrRadiusChange(this.getId());
            this.env.notifyAgentPositionOrRadiusChange(this.getCreatorId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void updatePosition(AbstractWorkspacePoint pos) {
        this.position = pos;
        try {
            this.env.notifyArtifactPositionOrRadiusChange(this.getId());
            this.env.notifyAgentPositionOrRadiusChange(this.getCreatorId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected double getObservingRadius() {
        return this.observingRadius;
    }

    protected void setObservingRadius(double radius) {
        this.observingRadius = radius;
        try {
            this.env.notifyAgentPositionOrRadiusChange(this.getCreatorId());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void addFocusedArtifact(String wspName, String artName, ArtifactId id) {
        this.defineObsProperty("focused_art", wspName, artName, id);
    }

    void removeFocusedArtifact(String wspName, String artName, ArtifactId id) {
        this.removeObsPropertyByTemplate(wspName, artName, null);
    }
}

