/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AgentBodyArtifact;
import cartago.AgentId;
import cartago.ArtifactDescriptor;
import cartago.ArtifactId;
import cartago.CartagoException;
import cartago.IAlignmentTest;
import cartago.ICartagoCallback;
import cartago.ICartagoContext;
import cartago.ObservableArtifactInfo;
import cartago.Op;
import cartago.WorkspaceId;
import cartago.WorkspaceKernel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AgentBody
implements ICartagoContext {
    private AgentId id;
    private WorkspaceKernel wspKernel;
    protected ICartagoCallback agentCallback;
    protected LinkedList<ArtifactDescriptor> focusedArtifacts;
    protected AgentBodyArtifact bodyArtifact;

    AgentBody(AgentId id, WorkspaceKernel env, ICartagoCallback agentCallback) {
        this.id = id;
        this.wspKernel = env;
        this.agentCallback = agentCallback;
        this.focusedArtifacts = new LinkedList();
        this.bodyArtifact = null;
    }

    @Override
    public AgentId getAgentId() {
        return this.id;
    }

    @Override
    public WorkspaceId getWorkspaceId() {
        return this.wspKernel.getId();
    }

    public WorkspaceKernel getWSPKernel() {
        return this.wspKernel;
    }

    public void setBodyArtifact(AgentBodyArtifact art) {
        this.bodyArtifact = art;
    }

    public AgentBodyArtifact getAgentBodyArtifact() {
        return this.bodyArtifact;
    }

    @Override
    public void doAction(long actionId, ArtifactId aid, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        if (timeout == -1L) {
            timeout = Integer.MAX_VALUE;
        }
        this.wspKernel.execOp(actionId, this.id, this.agentCallback, aid, op, timeout, test);
    }

    @Override
    public boolean doAction(long actionId, String name, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        if (timeout == -1L) {
            timeout = Integer.MAX_VALUE;
        }
        return this.wspKernel.execOp(actionId, this.id, this.agentCallback, name, op, timeout, test);
    }

    @Override
    public boolean doAction(long actionId, Op op, IAlignmentTest test, long timeout) throws CartagoException {
        if (timeout == -1L) {
            timeout = Integer.MAX_VALUE;
        }
        return this.wspKernel.execOp(actionId, this.id, this.agentCallback, op, timeout, test);
    }

    public void addFocusedArtifacts(ArtifactDescriptor des) {
        this.focusedArtifacts.add(des);
        if (this.bodyArtifact != null) {
            this.bodyArtifact.beginExternalSession();
            this.bodyArtifact.addFocusedArtifact(des.getArtifact().getId().getWorkspaceId().getName(), des.getArtifact().getId().getName(), des.getArtifact().getId());
            this.bodyArtifact.endExternalSession(true);
        }
    }

    public void removeFocusedArtifacts(ArtifactDescriptor des) {
        this.focusedArtifacts.remove(des);
    }

    public ICartagoCallback getCallback() {
        return this.agentCallback;
    }

    public boolean isObserving(ArtifactId id) {
        for (ArtifactDescriptor des : this.focusedArtifacts) {
            if (!des.getArtifact().getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void updateObsArtifactListWith(List<ObservableArtifactInfo> list, List<ObservableArtifactInfo> stopFocus, List<ObservableArtifactInfo> newFocus) {
        Iterator itd = this.focusedArtifacts.iterator();
        while (itd.hasNext()) {
            ArtifactDescriptor des = (ArtifactDescriptor)itd.next();
            boolean found = false;
            Iterator<ObservableArtifactInfo> it = list.iterator();
            while (it.hasNext()) {
                ObservableArtifactInfo el = it.next();
                if (el.getTargetArtifact().getId() != des.getArtifact().getId().getId()) continue;
                found = true;
                it.remove();
                break;
            }
            if (found) continue;
            stopFocus.add(new ObservableArtifactInfo(des.getArtifact().getId(), des.getAdapter().readProperties()));
            itd.remove();
        }
        for (ObservableArtifactInfo el : list) {
            newFocus.add(el);
            this.focusedArtifacts.add(el.getDescriptor());
        }
    }
}

