/*
 * Decompiled with CFR 0.152.
 */
package cartago;

import cartago.AgentId;
import cartago.AgentJoinRequestInfo;
import cartago.AgentQuitRequestInfo;
import cartago.ArtifactConfig;
import cartago.ArtifactId;
import cartago.ArtifactObsProperty;
import cartago.CartagoException;
import cartago.Op;
import cartago.OpRequestInfo;
import cartago.Tuple;
import cartago.WorkspaceKernel;
import cartago.events.ActionSucceededEvent;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractWSPRuleEngine {
    private ReentrantLock lock = new ReentrantLock();
    private WorkspaceKernel kernel;

    protected AbstractWSPRuleEngine() {
    }

    protected void processActionRequest(OpRequestInfo desc) {
    }

    protected void processAgentJoinRequest(AgentJoinRequestInfo req) {
    }

    protected void processAgentQuitRequest(AgentQuitRequestInfo req) {
    }

    protected final boolean execOp(ArtifactId aid, Op op) throws CartagoException {
        return this.kernel.wspRuleManExecOp(aid, op);
    }

    protected final ArtifactId makeArtifact(String artifactName, String templateName, Object ... params) throws CartagoException {
        AgentId id = this.kernel.getWSPManager().getAgentId();
        return this.kernel.makeArtifact(id, artifactName, templateName, new ArtifactConfig(params));
    }

    protected final void disposeArtifact(ArtifactId id) throws CartagoException {
        AgentId aid = this.kernel.getWSPManager().getAgentId();
        this.kernel.disposeArtifact(aid, id);
    }

    protected final String[] getArtifactList() {
        return this.kernel.getArtifactList();
    }

    protected final ArtifactId getArtifact(String name) {
        return this.kernel.getArtifact(name);
    }

    protected final ArtifactObsProperty getArtifactObsProp(ArtifactId id, String propName) throws CartagoException {
        return this.kernel.wspRuleManReadObsProperty(id, propName);
    }

    protected final void lock() throws InterruptedException {
        this.lock.lock();
    }

    protected final void unlock() throws InterruptedException {
        this.lock.unlock();
    }

    void setKernel(WorkspaceKernel kernel) {
        this.kernel = kernel;
    }

    protected void processObsPropertyChanged(ArtifactId sourceId, ArtifactObsProperty[] changed) {
    }

    protected void processObsPropertyAdded(ArtifactId sourceId, ArtifactObsProperty[] added) {
    }

    protected void processObsPropertyRemoved(ArtifactId sourceId, ArtifactObsProperty[] removed) {
    }

    protected void processActionCompleted(ActionSucceededEvent ev, AgentId userId) {
    }

    protected void processSignal(Tuple signal) {
    }
}

