/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.IAsset;
import sidekick.SideKickParsedData;
import sidekick.SideKickPlugin;
import sidekick.SideKickUpdate;

public class SideKickTree
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    private RolloverButton parseBtn;
    protected JTree tree;
    protected boolean treeFollowsCaret;
    protected View view;
    private Timer caretTimer;
    protected SideKickParsedData data;

    public SideKickTree(View view, boolean docked) {
        super(new BorderLayout());
        this.view = view;
        JToolBar buttonBox = new JToolBar();
        buttonBox.setFloatable(false);
        this.parseBtn = new RolloverButton(GUIUtilities.loadIcon((String)"Parse.png"));
        this.parseBtn.setToolTipText(jEdit.getProperty((String)"sidekick-tree.parse"));
        this.parseBtn.setMargin(new Insets(0, 0, 0, 0));
        this.parseBtn.setRequestFocusEnabled(false);
        this.parseBtn.addActionListener(this.buildActionListener());
        buttonBox.add((Component)this.parseBtn);
        buttonBox.add(Box.createGlue());
        this.add("North", buttonBox);
        DefaultTreeModel emptyModel = new DefaultTreeModel(new DefaultMutableTreeNode(null));
        this.tree = this.buildTree(emptyModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addKeyListener(new KeyHandler());
        if (docked) {
            this.tree.addMouseMotionListener(new MouseHandler());
        }
        if (!OperatingSystem.isMacOSLF()) {
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.tree.setVisibleRowCount(10);
        this.tree.setCellRenderer(new Renderer());
        this.add("Center", new JScrollPane(this.tree));
        this.propertiesChanged();
        CaretHandler caretListener = new CaretHandler();
        EditPane[] editPanes = view.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            editPanes[i].getTextArea().addCaretListener((CaretListener)caretListener);
        }
        this.update();
    }

    public void focusOnDefaultComponent() {
        this.tree.requestFocus();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus((EBComponent)this);
    }

    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus((EBComponent)this);
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)msg;
            EditPane editPane = epu.getEditPane();
            if (epu.getWhat() == EditPaneUpdate.CREATED) {
                editPane.getTextArea().addCaretListener((CaretListener)new CaretHandler());
            }
        } else if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (msg instanceof SideKickUpdate && ((SideKickUpdate)msg).getView() == this.view) {
            this.update();
        }
    }

    protected void update() {
        this.data = SideKickParsedData.getParsedData(this.view);
        if (SideKickPlugin.getParserForBuffer(this.view.getBuffer()) == null || this.data == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.view.getBuffer().getName());
            root.insert(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.not-parsed")), 0);
            this.tree.setModel(new DefaultTreeModel(root));
        } else {
            this.tree.setModel(this.data.tree);
            if (this.treeFollowsCaret) {
                this.expandTreeAt(this.view.getTextArea().getCaretPosition());
            }
        }
    }

    protected JTree buildTree(DefaultTreeModel model) {
        return new CustomTree(model);
    }

    protected ActionListener buildActionListener() {
        return new ActionHandler();
    }

    private void propertiesChanged() {
        this.treeFollowsCaret = jEdit.getBooleanProperty((String)"sidekick-tree.follows-caret");
    }

    protected void expandTreeWithDelay() {
        if (this.caretTimer != null) {
            this.caretTimer.stop();
        }
        this.caretTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int caret;
                JEditTextArea textArea = SideKickTree.this.view.getTextArea();
                Selection s = textArea.getSelectionAtOffset(caret = textArea.getCaretPosition());
                SideKickTree.this.expandTreeAt(s == null ? caret : s.getStart());
            }
        });
        this.caretTimer.setInitialDelay(500);
        this.caretTimer.setRepeats(false);
        this.caretTimer.start();
    }

    protected void expandTreeAt(int dot) {
        if (this.data == null) {
            return;
        }
        TreePath treePath = this.data.getTreePathForPosition(dot);
        if (treePath != null) {
            this.tree.expandPath(treePath);
            this.tree.setSelectionPath(treePath);
            this.tree.scrollPathToVisible(treePath);
        }
    }

    class Renderer
    extends DefaultTreeCellRenderer {
        Renderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeValue = node.getUserObject();
            if (nodeValue instanceof IAsset) {
                IAsset asset = (IAsset)node.getUserObject();
                this.setText(asset.getShortString());
                this.setIcon(asset.getIcon());
            } else if (node.getParent() == null) {
                this.setIcon(FileCellRenderer.fileIcon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    class MouseHandler
    extends MouseMotionAdapter {
        MouseHandler() {
        }

        public void mouseMoved(MouseEvent evt) {
            TreePath path = SideKickTree.this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (path == null) {
                SideKickTree.this.view.getStatus().setMessage(null);
            } else {
                Object value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                if (value instanceof IAsset) {
                    SideKickTree.this.view.getStatus().setMessage(((IAsset)value).getLongString());
                }
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (SideKickTree.this.caretTimer != null) {
                SideKickTree.this.caretTimer.stop();
            }
            if (evt.getKeyCode() == 10) {
                Object value;
                evt.consume();
                TreePath path = SideKickTree.this.tree.getSelectionPath();
                if (path != null && (value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof IAsset) {
                    IAsset asset = (IAsset)value;
                    JEditTextArea textArea = SideKickTree.this.view.getTextArea();
                    if (evt.isShiftDown()) {
                        textArea.setCaretPosition(asset.getEnd().getOffset());
                        textArea.addToSelection((Selection)new Selection.Range(asset.getStart().getOffset(), asset.getEnd().getOffset()));
                    } else {
                        textArea.setCaretPosition(asset.getStart().getOffset());
                    }
                }
            }
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        public void caretUpdate(CaretEvent evt) {
            if (evt.getSource() == SideKickTree.this.view.getTextArea() && SideKickTree.this.treeFollowsCaret) {
                SideKickTree.this.expandTreeWithDelay();
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            SideKickPlugin.parse(SideKickTree.this.view, true);
        }
    }

    protected class CustomTree
    extends JTree {
        protected CustomTree(TreeModel model) {
            super(model);
        }

        protected void processMouseEvent(MouseEvent evt) {
            switch (evt.getID()) {
                case 501: {
                    Object value;
                    TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
                    if (path != null && (value = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof IAsset) {
                        IAsset asset = (IAsset)value;
                        JEditTextArea textArea = SideKickTree.this.view.getTextArea();
                        if (evt.getClickCount() == 2) {
                            this.doubleClicked(SideKickTree.this.view, asset, path);
                        } else if (evt.isShiftDown()) {
                            this.shiftClick(SideKickTree.this.view, asset, path);
                        } else if (evt.isControlDown()) {
                            this.controlClick(SideKickTree.this.view, asset, path);
                        } else {
                            textArea.setCaretPosition(asset.getStart().getOffset());
                        }
                    }
                    super.processMouseEvent(evt);
                    break;
                }
                case 505: {
                    SideKickTree.this.view.getStatus().setMessage(null);
                    super.processMouseEvent(evt);
                    break;
                }
                default: {
                    super.processMouseEvent(evt);
                }
            }
        }

        protected void doubleClicked(View view, IAsset asset, TreePath path) {
        }

        protected void shiftClick(View view, IAsset asset, TreePath path) {
            JEditTextArea textArea = view.getTextArea();
            textArea.setCaretPosition(asset.getEnd().getOffset());
            textArea.addToSelection((Selection)new Selection.Range(asset.getStart().getOffset(), asset.getEnd().getOffset()));
        }

        protected void controlClick(View view, IAsset asset, TreePath path) {
            JEditTextArea textArea = view.getTextArea();
            textArea.getDisplayManager().narrow(textArea.getLineOfOffset(asset.getStart().getOffset()), textArea.getLineOfOffset(asset.getEnd().getOffset()));
        }
    }
}

