/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import sidekick.SideKickCompletion;
import sidekick.SideKickParser;

public class SideKickCompletionPopup
extends JWindow {
    private View view;
    private JEditTextArea textArea;
    private JList list;
    private SideKickParser parser;
    private SideKickCompletion complete;
    private FocusListener textAreaFocusListener;
    private boolean handleFocusOnDispose;

    public static Point fitInScreen(Point p, Window w, int lineHeight) {
        Rectangle screenSize = w.getGraphicsConfiguration().getBounds();
        if (p.y + w.getHeight() >= screenSize.height) {
            p.y = p.y - w.getHeight() - lineHeight;
        }
        return p;
    }

    public SideKickCompletionPopup(View view, SideKickParser parser, int caret, SideKickCompletion complete) {
        super((Frame)view);
        this.view = view;
        this.parser = parser;
        this.textArea = view.getTextArea();
        this.list = new JList();
        this.list.addMouseListener(new MouseHandler());
        this.list.setSelectionMode(0);
        JScrollPane scroller = new JScrollPane(this.list, 22, 31);
        this.getContentPane().add((Component)scroller, "Center");
        KeyHandler keyHandler = new KeyHandler();
        this.addKeyListener(keyHandler);
        this.getRootPane().addKeyListener(keyHandler);
        this.list.addKeyListener(keyHandler);
        this.list.addListSelectionListener(new ListHandler());
        view.setKeyEventInterceptor((KeyListener)keyHandler);
        GUIUtilities.requestFocus((Window)this, (Component)this.list);
        this.complete = complete;
        this.updateListModel();
        Point location = this.textArea.offsetToXY(caret - complete.getTokenLength());
        location.y += this.textArea.getPainter().getFontMetrics().getHeight();
        SwingUtilities.convertPointToScreen(location, (Component)this.textArea.getPainter());
        this.setLocation(SideKickCompletionPopup.fitInScreen(location, this, this.textArea.getPainter().getFontMetrics().getHeight()));
        this.handleFocusOnDispose = true;
        this.textAreaFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SideKickCompletionPopup.this.handleFocusOnDispose = false;
                SideKickCompletionPopup.this.dispose();
            }
        };
        this.show();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SideKickCompletionPopup.this.textArea.requestFocus();
                SideKickCompletionPopup.this.textArea.addFocusListener(SideKickCompletionPopup.this.textAreaFocusListener);
            }
        });
    }

    public void dispose() {
        this.view.setKeyEventInterceptor(null);
        this.textArea.removeFocusListener(this.textAreaFocusListener);
        super.dispose();
        if (this.handleFocusOnDispose) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SideKickCompletionPopup.this.view.getTextArea().requestFocus();
                }
            });
        }
    }

    private void updateListModel() {
        if (this.complete == null || this.complete.size() == 0) {
            this.list.setListData(new String[]{jEdit.getProperty((String)"sidekick-complete.none")});
            this.list.setCellRenderer(new DefaultListCellRenderer());
            this.list.setVisibleRowCount(1);
        } else {
            this.setListModel(this.complete);
            this.list.setCellRenderer(this.complete.getRenderer());
            this.list.setVisibleRowCount(Math.min(8, this.complete.size()));
            this.list.setFixedCellHeight(this.list.getCellBounds((int)0, (int)0).height);
        }
        this.pack();
    }

    private void setListModel(final SideKickCompletion items) {
        ListModel model = new ListModel(){

            public int getSize() {
                return items.size();
            }

            public Object getElementAt(int index) {
                return items.get(index);
            }

            public void addListDataListener(ListDataListener l) {
            }

            public void removeListDataListener(ListDataListener l) {
            }
        };
        this.list.setModel(model);
        this.list.setSelectedIndex(0);
    }

    void updateSelection() {
        int index = this.list.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String description = this.complete.getCompletionDescription(index);
        this.view.getStatus().setMessageAndClear(description);
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (SideKickCompletionPopup.this.complete != null) {
                SideKickCompletionPopup.this.complete.handleKeystroke(SideKickCompletionPopup.this.list.getSelectedIndex(), '\n');
            }
            SideKickCompletionPopup.this.dispose();
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            SideKickCompletionPopup.this.updateSelection();
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if ((evt = KeyEventWorkaround.processKeyEvent((KeyEvent)evt)) == null) {
                return;
            }
            switch (evt.getKeyCode()) {
                case 10: {
                    this.keyTyped('\n');
                    evt.consume();
                    break;
                }
                case 9: {
                    this.keyTyped('\t');
                    evt.consume();
                    break;
                }
                case 27: {
                    SideKickCompletionPopup.this.dispose();
                    evt.consume();
                    break;
                }
                case 38: {
                    int selected = SideKickCompletionPopup.this.list.getSelectedIndex();
                    if (selected == 0) {
                        selected = SideKickCompletionPopup.this.list.getModel().getSize() - 1;
                    } else {
                        if (SideKickCompletionPopup.this.getFocusOwner() == SideKickCompletionPopup.this.list) {
                            return;
                        }
                        --selected;
                    }
                    SideKickCompletionPopup.this.list.setSelectedIndex(selected);
                    SideKickCompletionPopup.this.list.ensureIndexIsVisible(selected);
                    evt.consume();
                    break;
                }
                case 40: {
                    int selected = SideKickCompletionPopup.this.list.getSelectedIndex();
                    if (selected == SideKickCompletionPopup.this.list.getModel().getSize() - 1) {
                        selected = 0;
                    } else {
                        if (SideKickCompletionPopup.this.getFocusOwner() == SideKickCompletionPopup.this.list) {
                            return;
                        }
                        ++selected;
                    }
                    SideKickCompletionPopup.this.list.setSelectedIndex(selected);
                    SideKickCompletionPopup.this.list.ensureIndexIsVisible(selected);
                    evt.consume();
                    break;
                }
                case 32: {
                    break;
                }
                case 8: {
                    if (SideKickCompletionPopup.this.parser.canHandleBackspace()) {
                        this.keyPressedDefault(evt);
                        break;
                    }
                    SideKickCompletionPopup.this.dispose();
                    SideKickCompletionPopup.this.view.processKeyEvent(evt, true);
                    break;
                }
                case 127: {
                    SideKickCompletionPopup.this.dispose();
                    SideKickCompletionPopup.this.view.processKeyEvent(evt, true);
                    break;
                }
                default: {
                    this.keyPressedDefault(evt);
                }
            }
        }

        private void keyPressedDefault(KeyEvent evt) {
            if (!(evt.isControlDown() || evt.isAltDown() || evt.isMetaDown() || evt.isActionKey())) {
                return;
            }
            SideKickCompletionPopup.this.dispose();
            SideKickCompletionPopup.this.view.processKeyEvent(evt, true);
        }

        public void keyTyped(KeyEvent evt) {
            if ((evt = KeyEventWorkaround.processKeyEvent((KeyEvent)evt)) == null) {
                return;
            }
            char ch = evt.getKeyChar();
            if (ch == '\b' && !SideKickCompletionPopup.this.parser.canHandleBackspace()) {
                return;
            }
            this.keyTyped(ch);
            evt.consume();
        }

        private void keyTyped(char ch) {
            if (SideKickCompletionPopup.this.complete == null) {
                SideKickCompletionPopup.this.view.getTextArea().userInput(ch);
                SideKickCompletionPopup.this.dispose();
            } else if (SideKickCompletionPopup.this.complete.handleKeystroke(SideKickCompletionPopup.this.list.getSelectedIndex(), ch)) {
                EditPane editPane = SideKickCompletionPopup.this.view.getEditPane();
                int caret = editPane.getTextArea().getCaretPosition();
                if (!SideKickCompletionPopup.this.complete.updateInPlace(editPane, caret)) {
                    SideKickCompletionPopup.this.complete = SideKickCompletionPopup.this.parser.complete(editPane, caret);
                }
                SideKickCompletionPopup.this.updateListModel();
            } else {
                SideKickCompletionPopup.this.dispose();
            }
        }
    }
}

