/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public abstract class SideKickCompletion {
    protected View view;
    protected JEditTextArea textArea;
    protected String text;
    protected List items = new ArrayList();

    public SideKickCompletion() {
    }

    public SideKickCompletion(View view, String text) {
        this.view = view;
        this.textArea = view.getTextArea();
        this.text = text;
    }

    public SideKickCompletion(View view, String text, List items) {
        this(view, text);
        this.items = items;
    }

    public SideKickCompletion(View view, String text, Object[] items) {
        this(view, text);
        this.items = Arrays.asList(items);
    }

    public int size() {
        return this.items.size();
    }

    public Object get(int index) {
        return this.items.get(index);
    }

    public String getCompletionDescription(int index) {
        return null;
    }

    public boolean isCompletionSelectable(int index) {
        return true;
    }

    public boolean updateInPlace(EditPane editPane, int caret) {
        return false;
    }

    public ListCellRenderer getRenderer() {
        return new DefaultListCellRenderer();
    }

    public void insert(int index) {
        String selected = String.valueOf(this.get(index));
        String insert = selected.substring(this.text.length());
        this.textArea.setSelectedText(insert);
    }

    public int getTokenLength() {
        return this.text.length();
    }

    public boolean handleKeystroke(int selectedIndex, char keyChar) {
        if (keyChar == '\t' || keyChar == '\n') {
            this.insert(selectedIndex);
            return false;
        }
        if (keyChar == ' ') {
            this.insert(selectedIndex);
            this.textArea.userInput(' ');
            return false;
        }
        this.textArea.userInput(keyChar);
        return true;
    }
}

