/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import errorlist.DefaultErrorSource;
import errorlist.ErrorSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeAdapter;
import org.gjt.sp.jedit.buffer.BufferChangeListener;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.util.Log;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;
import sidekick.SideKickUpdate;

class SideKick
implements EBComponent {
    private View view;
    private EditPane editPane;
    private Buffer buffer;
    private SideKickParser parser;
    private DefaultErrorSource errorSource;
    private boolean showParsingMessage;
    private int delay;
    private Timer keystrokeTimer;
    private BufferChangeHandler bufferHandler;
    private boolean addedBufferChangeHandler;

    SideKick(View view) {
        this.view = view;
        this.bufferHandler = new BufferChangeHandler();
        this.propertiesChanged();
        this.keystrokeTimer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SideKick.this.parse(false);
            }
        });
        this.buffer = view.getBuffer();
        this.autoParse();
        EditBus.addToBus((EBComponent)this);
    }

    void parse(boolean showParsingMessage) {
        if (this.keystrokeTimer.isRunning()) {
            this.keystrokeTimer.stop();
        }
        if (!this.buffer.isLoaded()) {
            return;
        }
        if (SideKickPlugin.isParsingBuffer(this.buffer)) {
            return;
        }
        SideKickPlugin.startParsingBuffer(this.buffer);
        this.showParsingMessage = showParsingMessage;
        if (this.parser == null) {
            Log.log((int)1, (Object)this, (Object)"No parser");
            this.setErrorSource(null);
            this.showNotParsedMessage();
            SideKickPlugin.finishParsingBuffer(this.buffer);
            return;
        }
        if (showParsingMessage) {
            SideKickParsedData data = new SideKickParsedData(this.buffer.getName());
            data.root.add(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.parsing")));
            SideKickParsedData.setParsedData(this.view, data);
            this.sendUpdate();
        }
        DefaultErrorSource errorSource = new DefaultErrorSource("SideKick");
        SideKickParsedData[] data = new SideKickParsedData[1];
        SideKickPlugin.addWorkRequest(new ParseRequest(this.parser, this.buffer, errorSource, data), false);
        SideKickPlugin.addWorkRequest(new ParseAWTRequest(this.parser, this.buffer, errorSource, data), true);
    }

    void dispose() {
        this.setErrorSource(null);
        EditBus.removeFromBus((EBComponent)this);
        this.removeBufferChangeListener(this.buffer);
    }

    SideKickParser getParser() {
        return this.parser;
    }

    void setParser() {
        this.deactivateParser();
        this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
        this.activateParser();
        this.autoParse();
    }

    public void handleMessage(EBMessage msg) {
        PluginUpdate pmsg;
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (msg instanceof BufferUpdate) {
            this.handleBufferUpdate((BufferUpdate)msg);
        } else if (msg instanceof EditPaneUpdate) {
            this.handleEditPaneUpdate((EditPaneUpdate)msg);
        } else if (msg instanceof ViewUpdate) {
            this.handleViewUpdate((ViewUpdate)msg);
        } else if (msg instanceof PluginUpdate && ((pmsg = (PluginUpdate)msg).getWhat() == PluginUpdate.UNLOADED || pmsg.getWhat() == PluginUpdate.LOADED)) {
            this.setParser();
        }
    }

    private void autoParse() {
        if (this.buffer.getBooleanProperty("sidekick.buffer-change-parse") || this.buffer.getBooleanProperty("sidekick.keystroke-parse")) {
            this.parse(true);
        } else {
            this.showNotParsedMessage();
        }
    }

    private void setErrorSource(DefaultErrorSource errorSource) {
        int errorCount;
        if (this.errorSource != null) {
            ErrorSource.unregisterErrorSource((ErrorSource)this.errorSource);
            this.errorSource.clear();
        }
        this.errorSource = errorSource;
        if (errorSource != null && (errorCount = errorSource.getErrorCount()) != 0) {
            ErrorSource.registerErrorSource((ErrorSource)errorSource);
        }
    }

    private void addBufferChangeListener(Buffer buffer) {
        if (!this.addedBufferChangeHandler) {
            buffer.addBufferChangeListener((BufferChangeListener)this.bufferHandler);
            this.addedBufferChangeHandler = true;
        }
    }

    private void removeBufferChangeListener(Buffer buffer) {
        if (this.addedBufferChangeHandler) {
            buffer.removeBufferChangeListener((BufferChangeListener)this.bufferHandler);
            this.addedBufferChangeHandler = false;
        }
    }

    private void propertiesChanged() {
        try {
            this.delay = Integer.parseInt(jEdit.getProperty((String)"sidekick.auto-parse-delay"));
        }
        catch (NumberFormatException nf) {
            this.delay = 1500;
        }
    }

    private void showNotParsedMessage() {
        this.setErrorSource(null);
        SideKickParsedData data = new SideKickParsedData(this.buffer.getName());
        data.root.add(new DefaultMutableTreeNode(jEdit.getProperty((String)"sidekick-tree.not-parsed")));
        SideKickParsedData.setParsedData(this.view, data);
        this.sendUpdate();
    }

    private void parseWithDelay() {
        if (this.parser != null) {
            this.parser.stop();
            if (this.keystrokeTimer.isRunning()) {
                this.keystrokeTimer.stop();
            }
            this.keystrokeTimer.setInitialDelay(this.delay);
            this.keystrokeTimer.setRepeats(false);
            this.keystrokeTimer.start();
        }
    }

    private void sendUpdate() {
        if (this.view.isClosed()) {
            return;
        }
        EditBus.send((EBMessage)new SideKickUpdate(this.view));
    }

    private void handleBufferUpdate(BufferUpdate bmsg) {
        if (bmsg.getBuffer() == this.buffer) {
            if (bmsg.getWhat() == BufferUpdate.SAVED || bmsg.getWhat() == BufferUpdate.LOADED) {
                this.autoParse();
            } else if (bmsg.getWhat() == BufferUpdate.PROPERTIES_CHANGED) {
                this.setParser();
            } else if (bmsg.getWhat() == BufferUpdate.CLOSED) {
                this.setErrorSource(null);
            }
        }
    }

    private void handleEditPaneUpdate(EditPaneUpdate epu) {
        EditPane editPane = epu.getEditPane();
        if (editPane.getView() != this.view) {
            return;
        }
        if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
            if (editPane == editPane.getView().getEditPane()) {
                this.removeBufferChangeListener(this.buffer);
                this.deactivateParser();
            }
        } else if (epu.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane == this.view.getEditPane()) {
            this.removeBufferChangeListener(this.buffer);
            this.deactivateParser();
            this.buffer = editPane.getBuffer();
            this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
            this.activateParser();
            this.autoParse();
        }
    }

    private void handleViewUpdate(ViewUpdate vu) {
        if (vu.getView() == this.view && vu.getWhat() == ViewUpdate.EDIT_PANE_CHANGED) {
            this.removeBufferChangeListener(this.buffer);
            this.deactivateParser();
            this.buffer = this.view.getBuffer();
            this.editPane = this.view.getEditPane();
            this.parser = SideKickPlugin.getParserForBuffer(this.buffer);
            this.activateParser();
            this.autoParse();
        }
    }

    private void deactivateParser() {
        if (this.parser != null) {
            if (this.editPane == null) {
                Log.log((int)9, (Object)this, (Object)"Null editPane!");
            } else {
                this.parser.deactivate(this.editPane);
            }
            this.editPane = null;
        }
    }

    private void activateParser() {
        EditPane editPane = this.view.getEditPane();
        if (this.parser != null) {
            this.addBufferChangeListener(this.buffer);
            this.editPane = editPane;
            this.parser.activate(editPane);
        } else {
            this.removeBufferChangeListener(this.buffer);
        }
    }

    class BufferChangeHandler
    extends BufferChangeAdapter {
        BufferChangeHandler() {
        }

        private void parseOnKeyStroke(Buffer buffer) {
            if (buffer != SideKick.this.buffer) {
                Log.log((int)9, (Object)((Object)this), (Object)("We have " + SideKick.this.buffer + " but got event for " + buffer));
                return;
            }
            if (buffer.isLoaded() && buffer.getBooleanProperty("sidekick.keystroke-parse")) {
                SideKick.this.parseWithDelay();
            }
        }

        public void contentInserted(Buffer buffer, int startLine, int offset, int numLines, int length) {
            this.parseOnKeyStroke(buffer);
        }

        public void contentRemoved(Buffer buffer, int startLine, int offset, int numLines, int length) {
            this.parseOnKeyStroke(buffer);
        }
    }

    class ParseAWTRequest
    implements Runnable {
        SideKickParser parser;
        Buffer buffer;
        SideKickParsedData[] data;
        DefaultErrorSource errorSource;

        ParseAWTRequest(SideKickParser parser, Buffer buffer, DefaultErrorSource errorSource, SideKickParsedData[] data) {
            this.parser = parser;
            this.buffer = buffer;
            this.data = data;
            this.errorSource = errorSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Log.log((int)1, (Object)this, (Object)"ParseAWTRequest");
                SideKick.this.setErrorSource(this.errorSource);
                int errorCount = this.errorSource.getErrorCount();
                if (SideKick.this.showParsingMessage || errorCount != 0) {
                    String label = jEdit.getProperty((String)("sidekick.parser." + this.parser.getName() + ".label"));
                    Object[] pp = new Object[]{label, new Integer(errorCount)};
                    SideKick.this.view.getStatus().setMessageAndClear(jEdit.getProperty((String)"sidekick.parsing-complete", (Object[])pp));
                }
                this.buffer.setProperty("sidekick.parsed-data", (Object)this.data[0]);
                if (this.buffer.getProperty((Object)"folding").equals("sidekick")) {
                    this.buffer.invalidateCachedFoldLevels();
                }
                for (View _view = jEdit.getFirstView(); _view != null; _view = _view.getNext()) {
                    if (_view.getBuffer() != this.buffer) continue;
                    SideKickParsedData.setParsedData(_view, this.data[0]);
                }
                SideKick.this.sendUpdate();
            }
            finally {
                SideKickPlugin.finishParsingBuffer(this.buffer);
            }
        }
    }

    static class ParseRequest
    implements Runnable {
        SideKickParser parser;
        Buffer buffer;
        DefaultErrorSource errorSource;
        SideKickParsedData[] data;

        ParseRequest(SideKickParser parser, Buffer buffer, DefaultErrorSource errorSource, SideKickParsedData[] data) {
            this.parser = parser;
            this.buffer = buffer;
            this.errorSource = errorSource;
            this.data = data;
        }

        public void run() {
            this.data[0] = this.parser.parse(this.buffer, this.errorSource);
        }
    }
}

