/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.HashSet;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EBPlugin;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.WorkThreadPool;
import sidekick.SideKick;
import sidekick.SideKickActions;
import sidekick.SideKickBindings;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;

public class SideKickPlugin
extends EBPlugin {
    public static final String PARSER_PROPERTY = "sidekick.parser";
    public static final String PARSED_DATA_PROPERTY = "sidekick.parsed-data";
    public static final String PARSE_COUNT = "sidekick.parse-count";
    private static HashMap sidekicks = new HashMap();
    private static HashMap parsers = new HashMap();
    private static WorkThreadPool worker;
    private static HashSet parsedBufferSet;

    public void start() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            this.initView(view);
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.initTextArea(panes[i].getTextArea());
            }
        }
        SideKickActions.propertiesChanged();
    }

    public void stop() {
        for (View view = jEdit.getFirstView(); view != null; view = view.getNext()) {
            this.uninitView(view);
            SideKickParsedData.setParsedData(view, null);
            EditPane[] panes = view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                this.uninitTextArea(panes[i].getTextArea());
            }
        }
        for (Buffer buffer = jEdit.getFirstBuffer(); buffer != null; buffer = buffer.getNext()) {
            buffer.setProperty(PARSED_DATA_PROPERTY, null);
        }
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof ViewUpdate) {
            ViewUpdate vu = (ViewUpdate)msg;
            View view = vu.getView();
            if (vu.getWhat() == ViewUpdate.CREATED) {
                this.initView(view);
            } else if (vu.getWhat() == ViewUpdate.CLOSED) {
                this.uninitView(view);
            }
        } else if (msg instanceof EditPaneUpdate) {
            EditPaneUpdate epu = (EditPaneUpdate)msg;
            EditPane editPane = epu.getEditPane();
            if (epu.getWhat() == EditPaneUpdate.CREATED) {
                this.initTextArea(editPane.getTextArea());
            } else if (epu.getWhat() == EditPaneUpdate.DESTROYED) {
                this.uninitTextArea(editPane.getTextArea());
            }
        } else if (msg instanceof BufferUpdate) {
            BufferUpdate bu = (BufferUpdate)msg;
            if (bu.getWhat() == BufferUpdate.CLOSED) {
                SideKickPlugin.finishParsingBuffer(bu.getBuffer());
            }
        } else if (msg instanceof PropertiesChanged) {
            SideKickActions.propertiesChanged();
        }
    }

    public static void registerParser(SideKickParser parser) {
        parsers.put(parser.getName(), parser);
    }

    public static void unregisterParser(SideKickParser parser) {
        parsers.remove(parser.getName());
    }

    public static SideKickParser getParser(String name) {
        SideKickParser parser = (SideKickParser)ServiceManager.getService((String)"sidekick.SideKickParser", (String)name);
        if (parser != null) {
            return parser;
        }
        return (SideKickParser)parsers.get(name);
    }

    public static SideKickParser getParserForView(View view) {
        SideKick sidekick = (SideKick)sidekicks.get(view);
        if (sidekick == null) {
            return null;
        }
        return sidekick.getParser();
    }

    public static SideKickParser getParserForBuffer(Buffer buffer) {
        String parserName = buffer.getStringProperty(PARSER_PROPERTY);
        if (parserName == null) {
            return null;
        }
        return SideKickPlugin.getParser(parserName);
    }

    public static void parse(View view, boolean showParsingMessage) {
        SideKick sidekick = (SideKick)sidekicks.get(view);
        sidekick.setParser();
        sidekick.parse(showParsingMessage);
    }

    public static void addWorkRequest(Runnable run, boolean inAWT) {
        if (worker == null) {
            worker = new WorkThreadPool("SideKick", 1);
            worker.start();
        }
        worker.addWorkRequest(run, inAWT);
    }

    public static boolean isParsingBuffer(Buffer buffer) {
        return parsedBufferSet.contains(buffer);
    }

    static void startParsingBuffer(Buffer buffer) {
        parsedBufferSet.add(buffer);
    }

    static void finishParsingBuffer(Buffer buffer) {
        parsedBufferSet.remove(buffer);
    }

    private void initView(View view) {
        sidekicks.put(view, new SideKick(view));
    }

    private void uninitView(View view) {
        SideKick sidekick = (SideKick)sidekicks.get(view);
        sidekick.dispose();
        sidekicks.remove(view);
    }

    private void initTextArea(JEditTextArea textArea) {
        SideKickBindings b = new SideKickBindings();
        textArea.putClientProperty((Object)SideKickBindings.class, (Object)b);
        textArea.addKeyListener((KeyListener)b);
    }

    private void uninitTextArea(JEditTextArea textArea) {
        SideKickBindings b = (SideKickBindings)textArea.getClientProperty((Object)SideKickBindings.class);
        textArea.putClientProperty((Object)SideKickBindings.class, null);
        textArea.removeKeyListener((KeyListener)b);
    }

    static {
        parsedBufferSet = new HashSet();
    }
}

