/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.View;
import org.gjt.sp.util.Log;
import sidekick.Asset;
import sidekick.IAsset;

public class SideKickParsedData {
    public DefaultTreeModel tree;
    public DefaultMutableTreeNode root;

    public static SideKickParsedData getParsedData(View view) {
        return (SideKickParsedData)view.getRootPane().getClientProperty("sidekick.parsed-data");
    }

    public static void setParsedData(View view, SideKickParsedData data) {
        Log.log((int)1, (Object)SideKickParsedData.class, (Object)("Setting parsed data of " + view + " to " + data));
        view.getRootPane().putClientProperty("sidekick.parsed-data", data);
    }

    public SideKickParsedData(String fileName) {
        this.root = new DefaultMutableTreeNode(fileName);
        this.tree = new DefaultTreeModel(this.root);
    }

    public TreePath getTreePathForPosition(int dot) {
        if (this.root.getChildCount() == 0) {
            return null;
        }
        ArrayList<DefaultMutableTreeNode> _path = new ArrayList<DefaultMutableTreeNode>();
        for (int i = this.root.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(i);
            if (!this.getTreePathForPosition(node, dot, _path)) continue;
            _path.add(node);
            break;
        }
        if (_path.size() == 0) {
            return null;
        }
        Object[] path = new Object[_path.size() + 1];
        path[0] = this.root;
        int len = _path.size();
        for (int i = 0; i < len; ++i) {
            path[i + 1] = _path.get(len - i - 1);
        }
        TreePath treePath = new TreePath(path);
        return treePath;
    }

    private boolean getTreePathForPosition(TreeNode node, int dot, List path) {
        int childCount = node.getChildCount();
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        if (!(userObject instanceof IAsset)) {
            return false;
        }
        IAsset asset = (IAsset)userObject;
        if (dot >= asset.getStart().getOffset() && dot <= asset.getEnd().getOffset()) {
            for (int i = childCount - 1; i >= 0; --i) {
                TreeNode _node = node.getChildAt(i);
                if (!this.getTreePathForPosition(_node, dot, path)) continue;
                path.add(_node);
                return true;
            }
            return true;
        }
        return false;
    }

    public Asset getAssetAtPosition(int pos) {
        return (Asset)this.getAssetAtOffset(pos);
    }

    public IAsset getAssetAtOffset(int pos) {
        TreePath path = this.getTreePathForPosition(pos);
        if (path == null) {
            return null;
        }
        return (IAsset)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
    }
}

