/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;

public class SideKickOptionPane
extends AbstractOptionPane {
    private JCheckBox bufferChangeParse;
    private JCheckBox keystrokeParse;
    private JSlider autoParseDelay;
    private JCheckBox treeFollowsCaret;
    private JCheckBox completeInstantToggle;
    private JCheckBox completeDelayToggle;
    private JSlider completeDelay;

    public SideKickOptionPane() {
        super("sidekick");
    }

    protected void _init() {
        int autoParseDelayValue;
        this.treeFollowsCaret = new JCheckBox(jEdit.getProperty((String)"options.sidekick.tree-follows-caret"));
        this.addComponent(this.treeFollowsCaret);
        this.treeFollowsCaret.setSelected(jEdit.getBooleanProperty((String)"sidekick-tree.follows-caret"));
        this.treeFollowsCaret.addActionListener(new ActionHandler());
        this.bufferChangeParse = new JCheckBox(jEdit.getProperty((String)"options.sidekick.buffer-change-parse"));
        this.addComponent(this.bufferChangeParse);
        this.bufferChangeParse.setSelected(jEdit.getBooleanProperty((String)"buffer.sidekick.buffer-change-parse"));
        this.bufferChangeParse.addActionListener(new ActionHandler());
        this.keystrokeParse = new JCheckBox(jEdit.getProperty((String)"options.sidekick.keystroke-parse"));
        this.addComponent(this.keystrokeParse);
        this.keystrokeParse.setSelected(jEdit.getBooleanProperty((String)"buffer.sidekick.keystroke-parse"));
        this.keystrokeParse.addActionListener(new ActionHandler());
        try {
            autoParseDelayValue = Integer.parseInt(jEdit.getProperty((String)"sidekick.auto-parse-delay"));
        }
        catch (NumberFormatException nf) {
            autoParseDelayValue = 1500;
        }
        this.addComponent(new JLabel(jEdit.getProperty((String)"options.sidekick.auto-parse-delay")));
        this.autoParseDelay = new JSlider(200, 3000, autoParseDelayValue);
        this.addComponent(this.autoParseDelay, 1);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 500; i <= 3000; i += 500) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 1000.0)));
        }
        this.autoParseDelay.setLabelTable(labelTable);
        this.autoParseDelay.setPaintLabels(true);
        this.autoParseDelay.setMajorTickSpacing(500);
        this.autoParseDelay.setPaintTicks(true);
        this.autoParseDelay.setEnabled(this.keystrokeParse.isSelected());
        this.completeInstantToggle = new JCheckBox(jEdit.getProperty((String)"options.sidekick.complete-instant.toggle"));
        this.addComponent(this.completeInstantToggle);
        this.completeInstantToggle.setSelected(jEdit.getBooleanProperty((String)"sidekick.complete-instant.toggle"));
        this.completeInstantToggle.addActionListener(new ActionHandler());
        this.completeDelayToggle = new JCheckBox(jEdit.getProperty((String)"options.sidekick.complete-delay.toggle"));
        this.addComponent(this.completeDelayToggle);
        this.completeDelayToggle.setSelected(jEdit.getBooleanProperty((String)"sidekick.complete-delay.toggle"));
        this.completeDelayToggle.addActionListener(new ActionHandler());
        int completeDelayValue = jEdit.getIntegerProperty((String)"sidekick.complete-delay", (int)500);
        this.addComponent(new JLabel(jEdit.getProperty((String)"options.sidekick.complete-delay")));
        this.completeDelay = new JSlider(0, 1500, completeDelayValue);
        this.addComponent(this.completeDelay, 1);
        labelTable = new Hashtable();
        for (int i = 0; i <= 1500; i += 250) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf((double)i / 1000.0)));
        }
        this.completeDelay.setLabelTable(labelTable);
        this.completeDelay.setPaintLabels(true);
        this.completeDelay.setMajorTickSpacing(250);
        this.completeDelay.setPaintTicks(true);
        this.completeDelay.setEnabled(this.completeDelayToggle.isSelected());
    }

    protected void _save() {
        jEdit.setBooleanProperty((String)"buffer.sidekick.buffer-change-parse", (boolean)this.bufferChangeParse.isSelected());
        jEdit.setBooleanProperty((String)"buffer.sidekick.keystroke-parse", (boolean)this.keystrokeParse.isSelected());
        jEdit.setProperty((String)"sidekick.auto-parse-delay", (String)String.valueOf(this.autoParseDelay.getValue()));
        jEdit.setBooleanProperty((String)"sidekick-tree.follows-caret", (boolean)this.treeFollowsCaret.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.complete-instant.toggle", (boolean)this.completeInstantToggle.isSelected());
        jEdit.setBooleanProperty((String)"sidekick.complete-delay.toggle", (boolean)this.completeDelayToggle.isSelected());
        jEdit.setIntegerProperty((String)"sidekick.complete-delay", (int)this.completeDelay.getValue());
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == SideKickOptionPane.this.keystrokeParse) {
                SideKickOptionPane.this.autoParseDelay.setEnabled(SideKickOptionPane.this.keystrokeParse.isSelected());
                if (SideKickOptionPane.this.keystrokeParse.isSelected()) {
                    SideKickOptionPane.this.bufferChangeParse.setSelected(true);
                }
            } else if (source == SideKickOptionPane.this.completeDelayToggle) {
                SideKickOptionPane.this.completeDelay.setEnabled(SideKickOptionPane.this.completeDelayToggle.isSelected());
            }
        }
    }
}

