/*
 * Decompiled with CFR 0.152.
 */
package sidekick;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import sidekick.IAsset;
import sidekick.SideKickCompletion;
import sidekick.SideKickCompletionPopup;
import sidekick.SideKickParsedData;
import sidekick.SideKickParser;
import sidekick.SideKickPlugin;

public class SideKickActions {
    public static final int COMPLETE_COMMAND = 0;
    public static final int COMPLETE_DELAY_KEY = 1;
    public static final int COMPLETE_INSTANT_KEY = 2;
    private static boolean completeDelay;
    private static boolean completeInstant;
    private static int delay;
    private static int caretWhenCompleteKeyPressed;
    private static Timer timer;
    private static SideKickCompletionPopup popup;

    public static void keyComplete(View view) {
        if (timer != null) {
            timer.stop();
        }
        if (!completeInstant) {
            return;
        }
        SideKickActions.complete(view, 2);
    }

    public static void keyCompleteWithDelay(final View view) {
        if (!completeDelay) {
            return;
        }
        if (timer != null) {
            timer.stop();
        }
        final JEditTextArea textArea = view.getTextArea();
        caretWhenCompleteKeyPressed = textArea.getCaretPosition();
        if (timer == null) {
            timer = new Timer(0, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (caretWhenCompleteKeyPressed == textArea.getCaretPosition()) {
                        SideKickActions.complete(view, 1);
                    }
                }
            });
            timer.setInitialDelay(delay);
            timer.setRepeats(false);
        }
        timer.start();
    }

    public static void complete(View view, int mode) {
        EditPane editPane = view.getEditPane();
        Buffer buffer = editPane.getBuffer();
        JEditTextArea textArea = editPane.getTextArea();
        SideKickParser parser = SideKickPlugin.getParserForBuffer(buffer);
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        SideKickCompletion complete = null;
        if (buffer.isEditable() && data != null && parser != null && parser.supportsCompletion()) {
            complete = parser.complete(editPane, textArea.getCaretPosition());
        }
        if (complete == null || complete.size() == 0) {
            if (mode == 2 || mode == 1) {
                return;
            }
            view.getToolkit().beep();
            return;
        }
        if (complete.size() == 1 && (mode == 0 || mode == 2)) {
            complete.insert(0);
            return;
        }
        if (popup != null) {
            return;
        }
        popup = new SideKickCompletionPopup(view, parser, textArea.getCaretPosition(), complete){

            public void dispose() {
                super.dispose();
                popup = null;
            }
        };
    }

    public static void selectAsset(View view) {
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        IAsset asset = data.getAssetAtOffset(textArea.getCaretPosition());
        if (asset == null || asset.getEnd() == null) {
            view.getToolkit().beep();
            return;
        }
        textArea.setCaretPosition(asset.getEnd().getOffset());
        textArea.addToSelection((Selection)new Selection.Range(asset.getStart().getOffset(), asset.getEnd().getOffset()));
    }

    public static void narrowToAsset(View view) {
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        TreePath path = data.getTreePathForPosition(textArea.getCaretPosition());
        if (path == null) {
            view.getToolkit().beep();
            return;
        }
        IAsset asset = (IAsset)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        if (asset == null || asset.getEnd() == null) {
            view.getToolkit().beep();
            return;
        }
        textArea.getDisplayManager().narrow(textArea.getLineOfOffset(asset.getStart().getOffset()), textArea.getLineOfOffset(asset.getStart().getOffset()));
    }

    public static void goToPrevAsset(View view) {
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        int caret = textArea.getCaretPosition();
        TreePath path = data.getTreePathForPosition(caret);
        if (path == null) {
            view.getToolkit().beep();
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            IAsset asset = (IAsset)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject();
            if (asset.getEnd() == null || caret != asset.getEnd().getOffset()) continue;
            textArea.setCaretPosition(asset.getStart().getOffset());
            return;
        }
        IAsset asset = (IAsset)node.getUserObject();
        if (caret == asset.getStart().getOffset()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            for (int i = 0; i < parent.getChildCount(); ++i) {
                if (node != parent.getChildAt(i)) continue;
                if (i == 0) {
                    if (parent.getUserObject() instanceof IAsset) {
                        textArea.setCaretPosition(((IAsset)parent.getUserObject()).getStart().getOffset());
                    }
                } else {
                    IAsset prevAsset = (IAsset)((DefaultMutableTreeNode)parent.getChildAt(i - 1)).getUserObject();
                    if (prevAsset.getEnd() != null) {
                        textArea.setCaretPosition(prevAsset.getEnd().getOffset());
                    }
                }
                return;
            }
        } else {
            textArea.setCaretPosition(asset.getStart().getOffset());
        }
    }

    public static void goToNextAsset(View view) {
        SideKickParsedData data = SideKickParsedData.getParsedData(view);
        if (data == null) {
            view.getToolkit().beep();
            return;
        }
        JEditTextArea textArea = view.getTextArea();
        int caret = textArea.getCaretPosition();
        TreePath path = data.getTreePathForPosition(caret);
        if (path == null) {
            view.getToolkit().beep();
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            IAsset asset = (IAsset)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject();
            if (caret != asset.getEnd().getOffset()) continue;
            if (i == node.getChildCount() - 1) break;
            IAsset nextAsset = (IAsset)((DefaultMutableTreeNode)node.getChildAt(i + 1)).getUserObject();
            textArea.setCaretPosition(nextAsset.getStart().getOffset());
            return;
        }
        textArea.setCaretPosition(((IAsset)node.getUserObject()).getEnd().getOffset());
    }

    public static void propertiesChanged() {
        completeDelay = jEdit.getBooleanProperty((String)"sidekick.complete-delay.toggle");
        completeInstant = jEdit.getBooleanProperty((String)"sidekick.complete-instant.toggle");
        delay = jEdit.getIntegerProperty((String)"sidekick.complete-delay", (int)500);
        if (timer != null) {
            timer.setInitialDelay(delay);
        }
    }
}

